% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_cre.R
\name{linear_cre}
\alias{linear_cre}
\title{Main Function for fitting correlated random effect linear model}
\usage{
linear_cre(data, Y.char, wb.char, other.char = NULL, ProvID.char, ...)
}
\arguments{
\item{data}{a data frame containing all variables.}

\item{Y.char}{a character string specifying the column name of the response variable in the \code{data}.}

\item{wb.char}{a character vector specifying covariates to be decomposed into
within (\code{*_within}) and between (\code{*_bar}) components.}

\item{other.char}{a character vector specifying additional covariates to include in the model without decomposition.}

\item{ProvID.char}{a character string specifying the column name of the provider identifier in the \code{data}.}

\item{\dots}{additional arguments passed to \code{\link[lme4]{lmer}} for further customization.}
}
\value{
A list of objects with S3 class \code{"linear_cre"}:
\item{coefficient}{a list containing the estimated coefficients:
\code{FE}, the fixed effects for each predictor and the intercept, and \code{RE}, the random effects for each provider.}
\item{variance}{a list containing the variance estimates:
\code{FE}, the variance-covariance matrix of the fixed effect coefficients, and \code{RE}, the variance of the random effects.}
\item{sigma}{the residual standard error.}
\item{fitted}{the fitted values of each individual.}
\item{observation}{the original response of each individual.}
\item{residuals}{the residuals of each individual, that is response minus fitted values.}
\item{linear_pred}{the linear predictor of each individual.}
\item{data_include}{the processed data used to fit the model, sorted by the provider identifier.
This includes the within-group (\code{*_within}) and between-group (\code{*_bar}) components for variables specified in \code{wb.char}.
For categorical covariates, it includes the dummy variables created for
all categories except the reference level.}
\item{char_list}{a list of the character vectors representing the column names for
the response variable, covariates, and provider identifier.
For categorical variables, the names reflect the dummy variables created for each category.}
\item{Loglkd}{the log-likelihood.}
\item{AIC}{Akaike information criterion.}
\item{BIC}{Bayesian information criterion.}
}
\description{
Fit a correlated  random effect linear model via \code{\link[lme4]{lmer}} from the \code{lme4} package.
}
\details{
Fit a correlated random effect linear model using \code{\link[lme4]{lmer}} with a Mundlak
within–between decomposition for selected covariates. For each
decomposed covariate \eqn{Z_k}, the function constructs
\eqn{Z_{k,\mathrm{bar},i} = \frac{1}{n_i}\sum_j Z_{k,ij}} (the group mean, "between")
and \eqn{Z_{k,\mathrm{within},ij} = Z_{k,ij} - Z_{k,\mathrm{bar},i}} (the within-group deviation),
and estimates
\deqn{Y_{ij} = \mu + \alpha_i + \sum_k \beta_{k,W} Z_{k,\mathrm{within},ij}
      + \sum_k \beta_{k,B} Z_{k,\mathrm{bar},i}
      + \mathbf{X}_{ij}^\top\gamma + \varepsilon_{ij},}
where \eqn{\alpha_i \sim \mathcal{N}(0,\sigma_\alpha^2)} is a random intercept.

The function creates, for every name in \code{wb.char}, two columns:
\code{<var>_bar} (group mean within \code{ProvID.char}) and
\code{<var>_within} (observation minus its group mean).
The fitted model is:
\preformatted{
  Y ~ <all *_within> + <all *_bar> + <other.char> + (1 | ProvID)
}

In addition to these input formats, all arguments from the \code{\link[lme4]{lmer}} function can be modified via \code{\dots},
allowing for customization of model fitting options such as controlling the optimization method or adjusting convergence criteria.
By default, the model is fitted using REML (restricted maximum likelihood).

If issues arise during model fitting, consider using the \code{data_check} function to perform a data quality check,
which can help identify missing values, low variation in covariates, high-pairwise correlation, and multicollinearity.
For datasets with missing values, this function automatically removes observations (rows) with any missing values before fitting the model.
}
\examples{
data(ExampleDataLinear)
outcome <- ExampleDataLinear$Y
covar <- ExampleDataLinear$Z
ProvID <- ExampleDataLinear$ProvID
data <- data.frame(outcome, ProvID, covar)
outcome.char <- colnames(data)[1]
ProvID.char <- colnames(data)[2]
wb.char <- c("z1", "z2")
other.char <- c("z3", "z4", "z5")

# Fit a correlated random effect linear model
fit_cre <- linear_cre(data = data, Y.char = outcome.char, ProvID.char = ProvID.char,
wb.char = wb.char, other.char = other.char)

}
\references{
Bates D, Maechler M, Bolker B, Walker S (2015). \emph{Fitting Linear Mixed-Effects Models Using lme4}.
Journal of Statistical Software, 67(1), 1-48.
\cr
}
\seealso{
\code{\link{data_check}}
}
