% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procrustes.R
\name{procrustes}
\alias{procrustes}
\title{procrustes}
\usage{
procrustes(z, w, ref = 1, dilation = FALSE)
}
\arguments{
\item{z}{A list of length \code{M}. \code{M} posterior samples of person latent positions \code{N} x \code{q}, where \code{N} is the number of respondents and \code{q} is the dimension of the interaction map.}

\item{w}{A list of length \code{M}. \code{M} posterior samples of item latent positions  \code{I} x \code{q}, where \code{I} is the number of items  and \code{q} is the dimension of the interaction map.}

\item{ref}{Reference configuration (i.e., iteration) index. Default is 1 (i.e., posterior samples at iteration 1) ).}

\item{dilation}{Logical; allow *uniform scaling* during alignment
(default \code{FALSE}). Set \code{TRUE} only for plotting/overlay use cases.}
}
\value{
A list of \code{M} matched posterior samples of \code{z}  and a list of \code{M} matched posterior samples of \code{w}.
}
\description{
Procrustes matching of posterior samples of latent positions of persons ( \code{z}) and items (\code{w}) from LSIRM with \code{q}-dimensional interaction map
}
\details{
The function performs Procrustes matching by aligning the \code{M}-1 posterior samples of \code{z} and \code{w} to the reference configuration (e.g., iteration 1). Users can select any configuration as the reference with the \code{ref} argument. The function returns \code{M} matched lists of \code{z} and \code{w} after the Procrustes matching process.
}
\examples{
# Load package
library(prolsirm)

# Generate example posterior samples
# M=3 samples of person latent positions (N=50, q=2)
z <- list(matrix(rnorm(100), ncol = 2),
          matrix(rnorm(100), ncol = 2),
          matrix(rnorm(100), ncol = 2))

# M=3 samples of item latent positions (I=5, q=2)
w <- list(matrix(rnorm(10), ncol = 2),
          matrix(rnorm(10), ncol = 2),
          matrix(rnorm(10), ncol = 2))

# Perform Procrustes matching
matched_data <- procrustes(z = z, w = w)

}
\references{
Borg and Groenen. 1997. \emph{Modern Multidimensional Scaling}.
New York: Springer. pp. 340-342.

Jeon, M., Jin, I. H., Schweinberger, M., & Baugh, S. 2021. \emph{Mapping Unobserved Item–Respondent Interactions: A Latent Space Item Response Model with Interaction Map}. Psychometrika, 86(2), 378–403.

Andrew D. Martin, Kevin M. Quinn, Jong Hee Park. 2011. MCMCpack: Markov Chain Monte Carlo in R. Journal of Statistical Software. 42(9): 1-21.
}
