% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biproportional-wto.R
\name{district_winner_matrix}
\alias{district_winner_matrix}
\title{Find which party has the most votes in a district}
\usage{
district_winner_matrix(votes_matrix, district_seats = 1L)
}
\arguments{
\item{votes_matrix}{Vote count matrix with votes by party in rows and votes by district
in columns.}

\item{district_seats}{Vector defining the number of seats per district. Must be the same
length as \code{ncol(votes_matrix)}. Values are name-matched to \code{votes_matrix} columns if both
are named. If a single value is supplied (like \code{1} as default), it is used as the number of
seats for every district.}
}
\value{
logical matrix with the same dimensions and names as \code{votes_matrix}
}
\description{
Create a logical matrix that shows whether a party got the most votes in a district or not.
}
\details{
If two or more parties are tied and there are not enough seats for each tied party,
the matrix value is \code{NA}.
}
\examples{
(vm = matrix(c(60,30,0,20,10,30), nrow = 3, dimnames = list(1:3, c("A", "B"))))

district_winner_matrix(vm)

# NA values if parties are tied (here in district B)
vm[1,2] <- 30
district_winner_matrix(vm)

# No NA values for tied parties if enough seats are available
district_winner_matrix(vm, c(1, 2))
}
