% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_interpro.R
\name{fetch_interpro}
\alias{fetch_interpro}
\title{Fetch domain and residue information from InterPro}
\usage{
fetch_interpro(
  uniprot_ids = NULL,
  return_residue_info = FALSE,
  manual_query = NULL,
  page_size = 200,
  max_tries = 3,
  timeout = 20,
  show_progress = TRUE
)
}
\arguments{
\item{uniprot_ids}{a character vector of UniProt accession numbers.}

\item{return_residue_info}{a logical value that specifies if either domain or residue information
should be returned by the function. The default is \code{FALSE}.}

\item{manual_query}{optional, a character value that is a custom query to the InterPro database.
This query is pastes after "https://www.ebi.ac.uk/interpro/api/" and before "&page_size=200".
The raw data of the query is returned as a list.}

\item{page_size}{a numeric value that specifies the number of entries that should be retrieved
per page of a request. The function anyway iterates through all pages, but this parameters allows you
to finetune the number of iterations and thus number of requests to the database. Default is 200.}

\item{max_tries}{a numeric value that specifies the number of times the function tries to download
the data in case an error occurs. The default is 3.}

\item{timeout}{a numeric value that specifies the maximum request time per try. Default is 20 seconds.}

\item{show_progress}{a logical value that determines if a progress bar will be shown. Default
is TRUE.}
}
\value{
A data frame that contains either domain or residue level information for the provided
UniProt IDs.
}
\description{
Fetches either domain level information with e.g. gene ontology annotations or
residue level information from the InterPro database.
}
\examples{
\donttest{
uniprot_ids <- c("P36578", "O43324", "Q00796", "O32583")

domain_info <- fetch_interpro(uniprot_ids = uniprot_ids)

head(domain_info)

residue_info <- fetch_interpro(
  uniprot_ids = uniprot_ids,
  return_residue_info = TRUE
)

head(residue_info)
}
}
