% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmap.R
\name{lmap}
\alias{lmap}
\alias{lmap_if}
\alias{lmap_at}
\title{Apply a function to list-elements of a list}
\usage{
lmap(.x, .f, ...)

lmap_if(.x, .p, .f, ..., .else = NULL)

lmap_at(.x, .at, .f, ...)
}
\arguments{
\item{.x}{A list or data frame.}

\item{.f}{A function that takes a length-1 list and returns a list (of any
length.)}

\item{...}{Additional arguments passed on to the mapped function.

We now generally recommend against using \code{...} to pass additional
(constant) arguments to \code{.f}. Instead use a shorthand anonymous function:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{# Instead of
x |> map(f, 1, 2, collapse = ",")
# do:
x |> map(\\(x) f(x, 1, 2, collapse = ","))
}\if{html}{\out{</div>}}

This makes it easier to understand which arguments belong to which
function and will tend to yield better error messages.}

\item{.p}{A single predicate function, a formula describing such a
predicate function, or a logical vector of the same length as \code{.x}.
Alternatively, if the elements of \code{.x} are themselves lists of
objects, a string indicating the name of a logical element in the
inner lists. Only those elements where \code{.p} evaluates to
\code{TRUE} will be modified.}

\item{.else}{A function applied to elements of \code{.x} for which \code{.p}
returns \code{FALSE}.}

\item{.at}{A logical, integer, or character vector giving the elements
to select. Alternatively, a function that takes a vector of names,
and returns a logical, integer, or character vector of elements to select.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}: if the tidyselect package is
installed, you can use \code{vars()} and tidyselect helpers to select
elements.}
}
\value{
A list or data frame, matching \code{.x}. There are no guarantees about
the length.
}
\description{
\code{lmap()}, \code{lmap_at()} and \code{lmap_if()} are similar to \code{map()}, \code{map_at()} and
\code{map_if()}, except instead of mapping over \code{.x[[i]]}, they instead map over
\code{.x[i]}.

This has several advantages:
\itemize{
\item It makes it possible to work with functions that exclusively take a list.
\item It allows \code{.f} to access the attributes of the encapsulating list,
like \code{\link[=names]{names()}}.
\item It allows \code{.f} to return a larger or small list than it receives
changing the size of the output.
}
}
\examples{
set.seed(1014)

# Let's write a function that returns a larger list or an empty list
# depending on some condition. It also uses the input name to name the
# output
maybe_rep <- function(x) {
  n <- rpois(1, 2)
  set_names(rep_len(x, n), paste0(names(x), seq_len(n)))
}

# The output size varies each time we map f()
x <- list(a = 1:4, b = letters[5:7], c = 8:9, d = letters[10])
x |> lmap(maybe_rep) |> str()

# We can apply f() on a selected subset of x
x |> lmap_at(c("a", "d"), maybe_rep) |> str()

# Or only where a condition is satisfied
x |> lmap_if(is.character, maybe_rep) |> str()
}
\seealso{
Other map variants: 
\code{\link{imap}()},
\code{\link{map}()},
\code{\link{map2}()},
\code{\link{map_depth}()},
\code{\link{map_if}()},
\code{\link{modify}()},
\code{\link{pmap}()}
}
\concept{map variants}
