% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_main_function.R
\name{.E_fit}
\alias{.E_fit}
\title{Fit an Efron model for a contingency table.}
\usage{
.E_fit(N, E, c0 = 1, pDegree = 5, aStart = 1, rel.tol)
}
\arguments{
\item{N}{an IxJ contingency table showing pairwise counts of
adverse events for I AEs (along the rows) and J drugs (along the columns).}

\item{E}{A matrix of expected counts under the null model for the SRS
frequency table.}

\item{c0}{numeric and greater than 0. It is a hyperparameter in "efron"
model.}

\item{pDegree}{integer greater than or equal to 2. It is a hyperparameter in
Efron model.}

\item{aStart}{initial value for parameter alpha in Efron model.}
}
\value{
a list of optimizer outputs
}
\description{
Fit an Efron model for a contingency table.
}
\details{
The implementation of the "efron" model is adapted from the
\pkg{deconvolveR} package, developed by Bradley Efron and
Balasubramanian Narasimhan. The original implementation in \pkg{deconvolveR}
does not support an exposure or offset parameter in the Poisson model,
which corresponds to the expected null value (\eqn{E_{ij}}) for each AE-drug
combination. To address this, we modified the relevant code to allow for the
inclusion of \eqn{E_{ij}} in the Poisson likelihood. In addition, we
implemented a method for estimating the degrees of freedom, enabling AIC- or
BIC-based hyperparameter selection for the "efron" model (Tan et al. 2025).
See \code{\link{pvEBayes_tune}} for details.
}
\references{
Narasimhan B, Efron B. deconvolveR: A G-modeling program for deconvolution
and empirical Bayes estimation. \emph{Journal of Statistical Software}.
2020; 2;94:1-20.

Tan Y, Markatou M and Chakraborty S. Flexible Empirical Bayesian Approaches
to Pharmacovigilance for Simultaneous Signal Detection and Signal Strength
Estimation in Spontaneous Reporting Systems Data.
\emph{Statistics in Medicine.} 2025; 44: 18-19,
https://doi.org/10.1002/sim.70195.
}
\keyword{internal}
