% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exact_age.R
\name{exact_age}
\alias{exact_age}
\title{Time elapsed (in years) since the dates of birth and event.}
\usage{
exact_age(
  date.birth,
  date.event,
  random.b = TRUE,
  random.e = TRUE,
  constant.age.year = FALSE
)
}
\arguments{
\item{date.birth}{A character vector with the dates of birth in format either "yyyy-mm-dd" or "yyyy-mm-dd hour:min:secs" (for instance, "2016-01-20 12:00:00") of a population.
If "hour:min:secs" is omitted the function imputes either "12:00:00", if `random.b = FALSE`, or
a random hour by default.}

\item{date.event}{A character vector with the dates of events in format either "yyyy-mm-dd" or "yyyy-mm-dd hour:min:secs" (for instance, "2016-01-20 12:00:00") of a population.
If "hour:min:secs" is omitted the function imputes either "12:00:00", if `random.e = FALSE`, or
a random hour, by default. This vector must have either length 1, when the aim is to compute
the exact age of all the members of the population in the same temporal point or the same
length as `date.birth` when the aim is to compute for each member
of the population the exact age in the moment of the event (e.g., death).}

\item{random.b}{A `TRUE/FALSE` argument indicating whether the exact moment ("hour:min:secs") when the birth occurs within the day is randomly selected. If TRUE, this overwrites "hour:min:secs" in `date.birth` even if those have been declared. By default, TRUE.}

\item{random.e}{A `TRUE/FALSE` argument indicating whether the exact moment ("hour:min:secs") when the event occurs within the day is randomly selected. If TRUE, this overwrites "hour:min:secs" in `date.event` even if those have been declared. By default, TRUE.}

\item{constant.age.year}{A `TRUE/FALSE` argument indicating whether the length of the year should be constant, 365.25 days, or variable,
depending on the time lived for the person in each year since her/his dates of birth and event. By default, FALSE.
The advantage of using a non-constant (person-dependent) length of year is congruence when
estimating time exposed at risk: in each year the time exposed along the time and age axes will coincide.}
}
\value{
A numeric vector of the same length as data.birth
}
\description{
Computes the time(s) elapsed (in years) between the date(s) of birth and the date(s) of event(s).
}
\note{
If `constant.age.year = FALSE` (default), the length of the year for each person is computed as a weighted average of the lengths
of the years that the person has lived between the dates of birth and event using as weight the time lived for the person during
each year.
}
\examples{
dates.b <- c("1920-05-13", "1999-04-12", "2019-01-01")
dates.e <- c("2002-03-23", "2009-04-12", "2019-01-01")
exact_age(dates.b, dates.e)
}
\references{
Pavia, JM and Lledo, J (2022). Estimation of the Combined Effects of Ageing and Seasonality on Mortality Risk. An application to Spain. *Journal of the Royal Statistical Society, Series A (Statistics in Society)*, 185(2), 471-497. \doi{10.1111/rssa.12769}

Pavia, JM and Lledo, J (2025). qlifetable: An R package for constructing quarterly life tables. *PLoS ONE*, 20(2), e0315937. \doi{10.1371/journal.pone.0315937}
}
\seealso{
\code{\link{coord_age}}, \code{\link{coord_time}}
}
\author{
Jose M. Pavia \email{pavia@uv.es}

Josep Lledo \email{josep.lledo@uv.es}
}
