% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/closedTesting.R
\name{closedTesting}
\alias{closedTesting}
\title{Closed testing for quantile regression}
\usage{
closedTesting(mod, X, tau = NULL, test = "rank-score", ...)
}
\arguments{
\item{mod}{An object of class \code{rqs} returned by
\code{\link[quantreg]{rq}}, representing the fitted quantile regression models.}

\item{X}{A string indicating the covariate of interest.}

\item{tau}{A numeric vector of quantiles of interest used in \code{mod}.
If \code{NULL} (default), all quantiles from the \code{mod} object are considered.}

\item{test}{Character. Type of test to be used. Options are
\code{"rank-score"} and \code{"wald"}.}

\item{...}{Additional arguments, see \code{\link[quasar]{rankTest}}, \code{\link[quasar]{waldTest}}.}
}
\value{
An object of class \code{quasar} containing:
\itemize{
  \item \code{Quantile}: quantile level
  \item \code{Coefficient}: estimated coefficient
  \item \code{Statistic}: test statistic
  \item \code{p.value}: raw \eqn{p}-value
  \item \code{p.value.adjusted}: adjusted \eqn{p}-value from the closed testing procedure
}
}
\description{
Applies the closed testing procedure to strongly control the familywise error rate (FWER)
when testing the effect of a covariate of interest across multiple quantile regression models.
}
\details{
This procedure requires that the covariate of interest \code{X} is either numeric
or, if categorical, has at most two levels. Multilevel categorical covariates
are not supported and will trigger an error.

The weighting matrix used in the multivariate rank test is the identity matrix, i.e.,
it is currently the only one implemented explicitly as a shortcut within the closed testing procedure.
}
\examples{
# Simulate data
set.seed(1234)
D <- simulateData(n = 100, gamma = 0.5, sigma.y = "1 + 2 * pmax(X, 0)")

# Quantile regressions at different levels
tau <- c(0.1, 0.25, 0.5, 0.75, 0.9)
mod <- quantreg::rq(y ~ X + Z1, tau = tau, data=D)

# Closed testing
res <- closedTesting(mod, X = "X")
res

# Summary and plot
summary(res, alpha = 0.1)
plot(res, alpha = 0.1, legend.position = "bottomright")
}
\references{
Marcus, R., Eric, P., & Gabriel, K. R. (1976).
On closed testing procedures with special reference to ordered analysis of variance.
\emph{Biometrika}, 63(3), 655--660.

Goeman, J. J., Hemerik, J., & Solari, A. (2021).
Only closed testing procedures are admissible for controlling false discovery proportions.
\emph{The Annals of Statistics}, 49(2), 1218--1238.
}
\seealso{
\code{\link[quantreg]{rq}}, \code{\link[quasar]{rankTest}}, \code{\link[quasar]{waldTest}}
}
\author{
Angela Andreella
}
