% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_categorical.R
\name{detect_categorical_outliers}
\alias{detect_categorical_outliers}
\title{Detect Rare Categories (Categorical Outliers)}
\usage{
detect_categorical_outliers(data, min_freq = 0.01)
}
\arguments{
\item{data}{A vector (character or factor).}

\item{min_freq}{Numeric. The minimum percentage (0 to 1) required to be considered normal.
Defaults to 0.01 (1 percent).}
}
\value{
A data frame summarizing the categories:
\item{Category}{The name of the level.}
\item{Count}{Absolute frequency.}
\item{Frequency}{Relative frequency.}
\item{Is_Outlier}{Logical flag.}
}
\description{
Identifies categories in a character or factor vector that appear less frequently
than a specified threshold.
}
\details{
The function calculates the relative frequency of each unique level.
If the frequency is below \code{min_freq}, the category is flagged as an outlier.
}
\examples{
cities <- c(rep("Madrid", 10), "Barcalona")
detect_categorical_outliers(cities, min_freq = 0.1)
}
