% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregated_input.R
\name{aggregated_input}
\alias{aggregated_input}
\title{aggregated_input helper function}
\usage{
aggregated_input(
  datatable,
  description = c("experimental", "calibration"),
  vec_cal,
  type = NULL
)
}
\arguments{
\item{datatable}{A data.table object that contains either the experimental
data or the calibration data.}

\item{description}{A character string, indicating if \code{datatable}
contains either \emph{"calibration"} data or \emph{"experimental"} data.}

\item{vec_cal}{The vector containing the CpG columns (output of \code{clean_dt}
with description = "calibration").}

\item{type}{A single integer. Type of data to be corrected: either \code{1L} (one
locus in many samples, e.g. pyrosequencing data) or \code{2L} (many loci in one
sample, e.g. next-generation sequencing data or microarray data).}
}
\value{
A data.table in the long format with aggregated means for each CpG
site of each sample and the corresponding standard deviation.
}
\description{
Internal function to present aggregated input data on which
calculations are performed. This function does only have an effect, if
repeated measurements are used for calibration a/o experimental data.
}
\examples{
experimental <- rBiasCorrection::example.data_experimental
calibration <- rBiasCorrection::example.data_calibration

vec_cal <- calibration$vec_cal

experimental_aggregated <- aggregated_input(
  datatable = experimental$dat,
  description = "experimental",
  vec_cal = vec_cal,
  type = 1
)
dim(experimental_aggregated)
class(experimental_aggregated)

calibration_aggregated <- aggregated_input(
  datatable = calibration$dat,
  description = "calibration",
  vec_cal = vec_cal
)
dim(calibration_aggregated)
class(calibration_aggregated)

}
