% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utility.R
\name{plotting_utility}
\alias{plotting_utility}
\title{plotting_utility helper function}
\usage{
plotting_utility(
  data,
  plotlist_reg,
  type,
  samplelocusname,
  locus_id = NULL,
  rv,
  mode = NULL,
  plotdir,
  logfilename,
  minmax,
  plot_height = 5,
  plot_width = 7.5,
  plot_textsize = 1
)
}
\arguments{
\item{data}{A data.table object that contains the calibration data.}

\item{plotlist_reg}{A list object contating regression plots without
regression curves (output of \code{regression_utility()}).}

\item{type}{A single integer. Type of data to be corrected: either \code{1L} (one
locus in many samples, e.g. pyrosequencing data) or \code{2L} (many loci in one
sample, e.g. next-generation sequencing data or microarray data).}

\item{samplelocusname}{A character string. In type 1 data: locus name -
name of the gene locus under investigation. In type 2 data: sample name -
name of the sample under investigation.}

\item{locus_id}{A character string. Default: NULL. ID of the respective
locus (only used in type 2 correction).}

\item{rv}{A list object. A list that contains additional objects needed
for the algorithms.}

\item{mode}{A character string. Default: NULL. Used to indicate "corrected"
calibration data.}

\item{plotdir}{A character string. Path to the folder,
where plots are saved.}

\item{logfilename}{A character string. Path to a file to save the log
messages (default = paste0(tempdir(), "/log.txt")).}

\item{minmax}{A logical, indicating which equations are used for
BiasCorrection (default: FALSE). If TRUE, equations are used that include
the respective minima and maxima of the provided data.}

\item{plot_height}{A integer value. The height (unit: inch) of the
resulting plots (default: 5).}

\item{plot_width}{A integer value. The width (unit: inch) of the
resulting plots (default: 7.5).}

\item{plot_textsize}{A integer value. The textsize of the
resulting plots (default: 16).}
}
\value{
This function creates calibration plots and writes them to the
local filesystem.
}
\description{
Internal function to carry out the plotting of the
calibrations curves.
}
\examples{
\donttest{
# define list object to save all data
rv <- list()
rv$minmax <- TRUE
rv$selection_method <- "RelError"
rv$sample_locus_name <- "Test"
rv$seed <- 1234

# define logfilename
logfilename <- paste0(tempdir(), "/log.txt")

# define plotdir
rv$plotdir <- paste0(tempdir(), "/plots/")
dir.create(rv$plotdir)

# import experimental file
exp_type_1 <- rBiasCorrection::example.data_experimental
rv$fileimport_experimental <- exp_type_1$dat

# import calibration file
cal_type_1 <- rBiasCorrection::example.data_calibration
rv$fileimport_calibration <- cal_type_1$dat
rv$vec_cal <- cal_type_1$vec_cal


# perform regression
regression_results <- regression_utility(
  rv$fileimport_calibration,
  "Testlocus",
  locus_id = NULL,
  rv = rv,
  mode = NULL,
  logfilename,
  minmax = rv$minmax,
  seed = rv$seed
)

# extract the plotlist
plotlist_reg <- regression_results$plot_list

plotting_utility(
  data = rv$fileimport_calibration,
  plotlist_reg = plotlist_reg,
  type = 1,
  samplelocusname = rv$sample_locus_name,
  locus_id = NULL,
  rv = rv,
  mode = NULL,
  plotdir = rv$plotdir,
  logfilename = logfilename,
  minmax = rv$minmax,
  plot_height = 5,
  plot_width = 7.5,
  plot_textsize = 1
)
}

}
