% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde_intrinsic.R
\name{rspde.intrinsic}
\alias{rspde.intrinsic}
\title{Rational approximations of fractional intrinsic fields}
\usage{
rspde.intrinsic(
  mesh,
  nu = NULL,
  nu.upper.bound = 2,
  mean.correction = FALSE,
  rspde.order = 1,
  prior.tau = NULL,
  prior.nu = NULL,
  prior.nu.dist = "lognormal",
  nu.prec.inc = 0.01,
  diagonal = 1e-05,
  type.rational.approx = "brasil",
  shared_lib = "detect",
  debug = FALSE,
  cache = TRUE,
  scaling = NULL,
  opts = NULL,
  ...
)
}
\arguments{
\item{mesh}{Spatial mesh for the FEM approximation.}

\item{nu}{If nu is set to a parameter, nu will be kept fixed and will not
be estimated. If nu is \code{NULL}, it will be estimated.}

\item{nu.upper.bound}{Upper bound for the smoothness parameter \eqn{\nu}. If \code{NULL}, it will be set to 2.}

\item{mean.correction}{Add mean correction for extreme value models?}

\item{rspde.order}{The order of the covariance-based rational SPDE approach. The default order is 1.}

\item{prior.tau}{A list specifying the prior for the variance parameter \eqn{\tau}.
This list may contain two elements: \code{mean} and/or \code{precision}, both of which must
be numeric scalars.}

\item{prior.nu}{a list containing the elements \code{mean} and \code{prec}
for beta distribution, or \code{loglocation} and \code{logscale} for a
truncated lognormal distribution. \code{loglocation} stands for
the location parameter of the truncated lognormal distribution in the log
scale. \code{prec} stands for the precision of a beta distribution.
\code{logscale} stands for the scale of the truncated lognormal
distribution on the log scale. Check details below.}

\item{prior.nu.dist}{The distribution of the smoothness parameter.
The current options are "beta" or "lognormal". The default is "lognormal".}

\item{nu.prec.inc}{Amount to increase the precision in the beta prior
distribution. Check details below.}

\item{diagonal}{Number added to diagonal of Q for increased stability.}

\item{type.rational.approx}{Which type of rational approximation
should be used? The current types are "brasil", "chebfun" or "chebfunLB".}

\item{shared_lib}{String specifying which shared library to use for the Cgeneric
implementation. Options are "detect", "INLA", or "rSPDE". You may also specify the
direct path to a .so (or .dll) file.}

\item{debug}{Logical value indicating whether to enable INLA debug mode.}

\item{cache}{Use caching internally in the estimation?}

\item{scaling}{A positive numeric value of length 1 for scaling the model.
If NULL (default), it will be computed using RSpectra::eigs.
Must be positive if provided.}

\item{opts}{A list of options passed to RSpectra::eigs function.
See RSpectra documentation for available options.}

\item{...}{Additional arguments passed internally for configuration purposes.}
}
\value{
An object of class \code{inla_rspde_intrinsic} representing the FEM approximation of
the intrinsic Gaussian random field.
}
\description{
\code{rspde.intrinsic} computes a Finite Element Method (FEM) approximation of a
Gaussian random field defined as the solution to the stochastic partial
differential equation (SPDE):
\deqn{(-\Delta)^{(\nu+d/2)/2}\tau u = W}.
}
