% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.r
\name{makeneurolik}
\alias{makeneurolik}
\title{Neural Two-Separator Likelihood}
\usage{
makeneurolik(a = 0.3)
}
\arguments{
\item{a}{Separation parameter controlling the spacing between the two logits.}
}
\value{
A function mapping a latent vector \code{z} to a probability vector.
}
\description{
Constructs a simple 3-category likelihood model based on a latent vector \code{z}.
The likelihood is defined by two logistic separators:
}
\details{
p1 = sigmoid(mean(z) - a)
p2 = sigmoid(mean(z) + a)

producing a 3-class probability vector:

(1 - p1, p1 - p2, p2)

This likelihood is useful for toy neural classification models or
simple latent-to-categorical mappings.
}
