% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbmi.R
\docType{package}
\name{rbmi-package}
\alias{rbmi}
\alias{rbmi-package}
\title{rbmi: Reference Based Multiple Imputation}
\description{
The \code{rbmi} package is used to perform reference based multiple imputation. The package
provides implementations for common, patient-specific imputation strategies whilst allowing the user to
select between various standard Bayesian and frequentist approaches.

The package is designed around 4 core functions:
\itemize{
\item \code{\link[=draws]{draws()}} - Fits multiple imputation models
\item \code{\link[=impute]{impute()}} - Imputes multiple datasets
\item \code{\link[=analyse]{analyse()}} - Analyses multiple datasets
\item \code{\link[=pool]{pool()}} - Pools multiple results into a single statistic
}

To learn more about \code{rbmi}, please see the quickstart vignette:

\code{vignette(topic= "quickstart", package = "rbmi")}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://openpharma.github.io/rbmi/}
  \item \url{https://github.com/openpharma/rbmi}
  \item Report bugs at \url{https://github.com/openpharma/rbmi/issues}
}

}
\author{
\strong{Maintainer}: Lukas A. Widmer \email{lukas_andreas.widmer@novartis.com}

Authors:
\itemize{
  \item Craig Gower-Page \email{craig.gower-page@novartis.com}
  \item Isaac Gravestock \email{isaac.gravestock@roche.com}
  \item Alessandro Noci \email{alessandro.noci@roche.com}
  \item Daniel Sabanes Bove \email{daniel.sabanes_bove@rconis.com}
}

Other contributors:
\itemize{
  \item Marcel Wolbers \email{marcel.wolbers@roche.com} [contributor]
  \item F. Hoffmann-La Roche AG [copyright holder, funder]
}

}
\keyword{internal}
