% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_plans.R
\name{redist.plot.plans}
\alias{redist.plot.plans}
\title{Plot a district assignment}
\usage{
redist.plot.plans(
  plans,
  draws,
  shp,
  qty = NULL,
  interactive = FALSE,
  ...,
  geom = NULL
)
}
\arguments{
\item{plans}{a \code{redist_plans} object.}

\item{draws}{the plan(s) to plot. Will match the \code{draw} column of \code{x}.}

\item{qty}{the quantity to plot. Defaults to the district assignment.}

\item{interactive}{if \code{TRUE}, show an interactive map in the viewer
rather than a static map. Only uses the first element of \code{draws}}

\item{...}{additional arguments passed to the plotting functions.}

\item{geom, shp}{the \code{redist_map} geometry to use (\code{geom} is deprecated).}
}
\value{
A ggplot
}
\description{
Plot a district assignment
}
\examples{
library(dplyr)
data(iowa)

iowa <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.05, total_pop = pop)
plans <- redist_smc(iowa, nsims = 100, silent = TRUE)
redist.plot.plans(plans, c(1, 2, 3, 4), iowa)

}
\concept{plot}
