% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{geomorphon_chunks_needed}
\alias{geomorphon_chunks_needed}
\title{Estimate Tile Processing Needs}
\usage{
geomorphon_chunks_needed(
  x,
  workers = Sys.getenv("R_RGEOMORPHON_N_WORKERS", unset = 1),
  scl_need = Sys.getenv("R_RGEOMORPHON_MEM_SCALE_NEED", unset = 10),
  scl_workers = Sys.getenv("R_RGEOMORPHON_MEM_SCALE_WORKERS", unset = 1),
  pow_total = Sys.getenv("R_RGEOMORPHON_MEM_POWER", unset = 0.5)
)
}
\arguments{
\item{x}{A \emph{SpatRaster} object.}

\item{workers}{\emph{integer}. Number of parallel workers. Default uses value of
environment variable \code{R_RGEOMORPHON_N_WORKERS}. If unset, \code{1}}

\item{scl_need}{\emph{numeric}. Scaling factor for memory needs. Default uses
value of environment variable \code{R_RGEOMORPHON_MEM_SCALE_NEED}. If unset,
\code{10}.}

\item{scl_workers}{\emph{numeric}. Scaling factor for each worker. Default uses
value of environment variable \code{R_RGEOMORPHON_MEM_SCALE_WORKERS}. If unset,
\code{1}.}

\item{pow_total}{\emph{numeric}. Exponent for scaling total number of chunks.
Default uses value of environment variable \code{R_RGEOMORPHON_MEM_POWER}. If
unset, \code{1}.}
}
\value{
\emph{integer}. Number of tile chunks to divide \code{x} into.
}
\description{
\code{geomorphon_chunks_needed()} is a heuristic for number of tiles needed to
calculate geomorphons on larger-than-memory rasters. Allows for scaling by
number of parallel workers, a multiplicative factor for the memory needs, and
a multiplicative factor for worker needs.
}
\examples{
\dontshow{if (requireNamespace("terra")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

data("salton", package = "rgeomorphon")

x <- terra::rast(salton)
terra::ext(x) <- attr(salton, "extent")
terra::crs(x) <- attr(salton, "crs")

geomorphon_chunks_needed(x)
\dontshow{\}) # examplesIf}
}
