% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacency_from_text.R
\name{adjacency_from_text}
\alias{adjacency_from_text}
\title{Create adjacency matrices from 'graph6', 'sparse6', or 'digraph6' symbols}
\usage{
adjacency_from_text(object, ...)
}
\arguments{
\item{object}{character vector of 'graph6', 'sparse6', or 'digraph6' symbols}

\item{...}{other arguments, currently ignored}
}
\value{
A list of adjacency matrices.
}
\description{
Create adjacency matrices from 'graph6', 'sparse6', or 'digraph6' symbols
}
\details{
If \code{object} contains 'sparse6' symbols, which are in fact encoded
edgelists, the function will return corresponding adjacency matrices
creating temporary igraph objects internally.
}
\examples{
# Graph6 symbols
sampleg6
adjacency_from_text(sampleg6)

# Sparse6 symbols
s6 <- c(":DgXI@G~", ":DgWCgCb")
adjacency_from_text(s6)

# Digraph6 symbol
d6 <- "&N????C??D?_G??C?????_?C_??????C??Q@O?G?"
adjacency_from_text(d6)

}
