% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/destructure.R
\name{\%<-\%}
\alias{\%<-\%}
\title{Destructure a named list into individual variables}
\usage{
lhs \%<-\% rhs
}
\arguments{
\item{lhs}{A call to \code{c()} containing variable names to assign to. All variable names should
exist in the rhs list.}

\item{rhs}{A named list containing the values to assign}
}
\value{
Invisibly returns the right-hand side list
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The destructuring operator \verb{\%<-\%} allows you to extract multiple named values from a list
into individual variables in a single assignment. This provides a convenient way to
unpack list elements by name.

While it works with any named list, it was primarily designed to improve the ergonomics
of working with Shiny modules that return multiple reactive values. Instead of manually
assigning each reactive value from a module's return list, you can destructure them all
at once.
}
\examples{
# Basic destructuring
data <- list(x = 1, y = 2, z = 3)
c(x, y) \%<-\% data
x  # 1
y  # 2

# Works with unsorted names
result <- list(last = "Smith", first = "John")
c(first, last) \%<-\% result

# Shiny module example
if (interactive()) {
  module_server <- function(id) {
    shiny::moduleServer(id, function(input, output, session) {
      list(
        value = shiny::reactive(input$num),
        text = shiny::reactive(input$txt)
      )
    })
  }

  # Clean extraction of reactive values
  c(value, text) \%<-\% module_server("my_module")
}

# Can be used with pipe operations
# Note: The piped expression must be wrapped in brackets
\dontrun{
c(value) \%<-\% (
  123 |>
    list(value = _)
)
}
}
