% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowscale.R
\name{rowscale.table}
\alias{rowscale.table}
\title{Scale a table by row}
\usage{
\method{rowscale}{table}(x, center = TRUE, scale = TRUE)
}
\arguments{
\item{x}{An matrix}

\item{center}{Logical, passed to \code{scale}. 
to \code{TRUE}}

\item{scale}{Logical, passed to \code{scale}. 
\code{TRUE}}
}
\value{
A table with each row scaled.
}
\description{
Scaling a table by row can be slightly slower due to a transposing step.
}
\examples{

letterDf <- data.frame(from=c("A", "A", "B", "C"), to=c("A", "B", "C", "A"))
tbl <- table(letterDf$from, letterDf$to)
tblRowscale <- rowscale(tbl)

print(tbl)
print(tblRowscale)
rowMeans(tblRowscale)
apply(tblRowscale, 1L, sd)

rowscale(tbl, center=FALSE, scale=FALSE) ## equal to mat
rowscale(tbl, center=TRUE, scale=FALSE)
rowscale(tbl, center=FALSE, scale=TRUE)

}
\seealso{
\code{\link{scale}}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
