% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/italic_checklist.R
\name{italic_checklist}
\alias{italic_checklist}
\title{Get species names in the checklist of the lichens of Italy}
\usage{
italic_checklist(
  include_bordering_countries = FALSE,
  genus = NULL,
  family = NULL,
  order = NULL,
  class = NULL,
  phylum = NULL
)
}
\arguments{
\item{include_bordering_countries}{Optional. Default FALSE. If TRUE the result includes also taxa occurring in bordering countries.}

\item{genus}{Optional. A genus name to filter the checklist.}

\item{family}{Optional. A family name to filter the checklist.}

\item{order}{Optional. An order name to filter the checklist.}

\item{class}{Optional. A class name to filter the checklist.}

\item{phylum}{Optional. A phylum name to filter the checklist.}
}
\value{
A character vector containing all accepted scientific names from the checklist of ITALIC.
}
\description{
Retrieves the complete list of accepted scientific names from the Checklist of
the Lichens of Italy in ITALIC. The function returns all accepted names of species occurring in Italy.
If the parameter include_bordering_countries is set to TRUE the function returns all the accepted names of species in ITALIC occurring both in Italy and in bordering countries.
}
\examples{
\dontrun{
# Get the complete checklist of Italy
italic_checklist()
# Get the complete checklist of Italy and bordering countries
italic_checklist(include_bordering_countries=TRUE)
# Get the checklist of the species of genus Lecanora
italic_checklist(genus ="Lecanora")
}

}
\references{
ITALIC - The Information System on Italian Lichens: checklist
\url{https://italic.units.it/index.php?procedure=checklist}
}
