/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats;

import jdplus.toolkit.base.api.dstats.BoundaryType;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.dstats.DStatException;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.stats.ProbabilityType;

public class Exponential
implements ContinuousDistribution {
    private final double scale;

    public Exponential(double scale) {
        this.scale = scale;
    }

    public double getRate() {
        return 1.0 / this.scale;
    }

    public double getScale() {
        return this.scale;
    }

    public double getDensity(double x) throws DStatException {
        if (x < 0.0) {
            return 0.0;
        }
        return Math.exp(-x / this.scale) / this.scale;
    }

    public double getLeftBound() {
        return 0.0;
    }

    public double getRightBound() {
        return Double.POSITIVE_INFINITY;
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Exponential with scale = ");
        sb.append(this.scale);
        return sb.toString();
    }

    public double getExpectation() throws DStatException {
        return this.scale;
    }

    public double getProbability(double x, ProbabilityType pt) throws DStatException {
        if (x <= 0.0) {
            return 0.0;
        }
        switch (pt) {
            case Lower: {
                return 1.0 - Math.exp(-x / this.scale);
            }
            case Upper: {
                return Math.exp(-x / this.scale);
            }
        }
        return 0.0;
    }

    public double getProbabilityInverse(double p, ProbabilityType pt) throws DStatException {
        if (p <= 0.0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        switch (pt) {
            case Lower: {
                return -Math.log(1.0 - p) * this.scale;
            }
            case Upper: {
                return -Math.log(p) * this.scale;
            }
        }
        return Double.NaN;
    }

    public double getVariance() throws DStatException {
        return this.scale * this.scale;
    }

    public BoundaryType hasLeftBound() {
        return BoundaryType.Finite;
    }

    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    public boolean isSymmetrical() {
        return false;
    }

    public double random(RandomNumberGenerator rng) throws DStatException {
        return Exponential.random(rng, this.scale);
    }

    public static double random(RandomNumberGenerator rng, double scale) {
        return -scale * Math.log(rng.nextDouble());
    }
}

