% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_td.R
\name{td_timevarying}
\alias{td_timevarying}
\title{Likelihood ratio test on time varying trading days}
\usage{
td_timevarying(s, groups = c(1, 2, 3, 4, 5, 6, 0), contrasts = FALSE)
}
\arguments{
\item{s}{The tested time series}

\item{groups}{The groups of days used to generate the regression variables.}

\item{contrasts}{The covariance matrix of the multivariate random walk model
used for the time-varying coefficients are related to the contrasts if TRUE,
on the actual number of days (all the days are driven by the same variance) if FALSE.}
}
\value{
A Chi2 test
}
\description{
Likelihood ratio test on time varying trading days
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
s <- log(ABS$X0.2.20.10.M)
td_timevarying(s)
\dontshow{\}) # examplesIf}
}
