% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generation.R
\name{add_parameter}
\alias{add_parameter}
\title{Expand a data frame with parameter combinations for simulation}
\usage{
add_parameter(df, ...)
}
\arguments{
\item{df}{A data frame to expand.}

\item{...}{Named vectors specifying parameter values to expand, provided as \code{param_name = values}.}
}
\value{
A \code{tibble} with added parameter columns for each combination of values.
}
\description{
Adds combinations of specified parameter values to a data frame for simulation by expanding over all combinations.
}
\examples{
df <- tibble::tibble(site = "A", condition = "control")
add_parameter(df, beta = c(0, 0.5), sigma = c(1, 2))
}
