% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity.R
\name{get_activity_logs}
\alias{get_activity_logs}
\title{Get activity logs}
\usage{
get_activity_logs(
  object_type = NULL,
  object_id = NULL,
  event_type = NULL,
  parent_project_id = NULL,
  parent_item_id = NULL,
  initiator_id = NULL,
  since = NULL,
  until = NULL,
  limit = 30,
  offset = 0,
  token = get_todoist_api_token()
)
}
\arguments{
\item{object_type}{filter by object type (e.g., "project", "item", "note")}

\item{object_id}{filter by specific object id}

\item{event_type}{filter by event type (e.g., "added", "updated", "completed")}

\item{parent_project_id}{filter by parent project id}

\item{parent_item_id}{filter by parent item id}

\item{initiator_id}{filter by user who initiated the action}

\item{since}{return events since this date (format: YYYY-MM-DDTHH:MM:SS)}

\item{until}{return events until this date (format: YYYY-MM-DDTHH:MM:SS)}

\item{limit}{maximum number of events to return (default 30, max 100)}

\item{offset}{offset for pagination}

\item{token}{todoist API token}
}
\value{
tibble of activity events
}
\description{
Get activity logs
}
\examples{
\dontrun{
get_activity_logs()
get_activity_logs(object_type = "item", event_type = "completed")
}
}
