% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfWishart.R
\name{swapMatListWithCube}
\alias{swapMatListWithCube}
\title{Swaps the matrix list with a cube}
\usage{
swapMatListWithCube(matrixListOrCube)
}
\arguments{
\item{matrixListOrCube}{Either a list of 2-dimensional matrices or a cube of matrices}
}
\value{
A list or a cube (opposite format as input)
}
\description{
Swaps the matrix list with a cube
}
\examples{

# Create matrix list
matLst <- cvPost(10, lotri::lotri(a+b~c(1, 0.25, 1)), 3)
print(matLst)

# Convert to cube
matCube <- swapMatListWithCube(matLst)
print(matCube)

# Convert back to list
matLst2 <- swapMatListWithCube(matCube)
print(matLst2)

}
\author{
Matthew L. Fidler
}
