% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend.R
\name{scMetaTraj_switchpoint}
\alias{scMetaTraj_switchpoint}
\title{Identify metabolic trajectory switchpoint}
\usage{
scMetaTraj_switchpoint(trend_df)
}
\arguments{
\item{trend_df}{Data frame with columns: mPT_bin and score_smooth.
Typically output from \code{\link{scMetaTraj_trend}}.}
}
\value{
A list with:
\item{mPT_switch}{Numeric. The mPT value at the switchpoint}
\item{index}{Integer. The index (row number) of the switchpoint in trend_df}
}
\description{
Identifies the point along metabolic pseudotime where a module shows
maximum change in trend (inflection point).
}
\examples{
# Create example trend data
set.seed(456)
n_cells <- 200
mPT <- runif(n_cells, 0, 1)

# Simulate trend with switchpoint at mPT = 0.5
scores <- ifelse(mPT < 0.5, 
                 0.3 + rnorm(n_cells, 0, 0.05),
                 0.7 + rnorm(n_cells, 0, 0.05))

# Compute trend
trend <- scMetaTraj_trend(scores, mPT, n_bins = 30, smooth = TRUE)

# Find switchpoint
switchpoint <- scMetaTraj_switchpoint(trend)
print(switchpoint$mPT_switch)

# Visualize
plot(trend$mPT_bin, trend$score_smooth, type = "l",
     xlab = "Metabolic pseudotime", ylab = "Module score")
abline(v = switchpoint$mPT_switch, col = "red", lty = 2)

}
