% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scTenifoldKnk.R
\name{scTenifoldKnk}
\alias{scTenifoldKnk}
\title{scTenifoldKNK}
\usage{
scTenifoldKnk(
  countMatrix,
  qc = TRUE,
  gKO = NULL,
  qc_mtThreshold = 0.1,
  qc_minLSize = 1000,
  qc_minCells = 25,
  nc_lambda = 0,
  nc_nNet = 10,
  nc_nCells = 500,
  nc_nComp = 3,
  nc_scaleScores = TRUE,
  nc_symmetric = FALSE,
  nc_q = 0.9,
  td_K = 3,
  td_maxIter = 1000,
  td_maxError = 1e-05,
  td_nDecimal = 3,
  ma_nDim = 2,
  nCores = parallel::detectCores()
)
}
\arguments{
\item{countMatrix}{countMatrix}

\item{qc}{A boolean value (TRUE/FALSE), if TRUE, a quality control is applied over the data.}

\item{gKO}{gKO}

\item{qc_mtThreshold}{A decimal value between 0 and 1. Defines the maximum ratio of mitochondrial reads (mithocondrial reads / library size) present in a cell to be included in the analysis. It's computed using the symbol genes starting with 'MT-' non-case sensitive.}

\item{qc_minLSize}{An integer value. Defines the minimum library size required for a cell to be included in the analysis.}

\item{qc_minCells}{An integer value. Defines the minimum number of cells a gene should be expressed in to be included in the analysis. By default, it's set to 25.}

\item{nc_lambda}{A continuous value between 0 and 1. Defines the multiplicative value (1-lambda) to be applied over the weaker edge connecting two genes to maximize the adjacency matrix directionality.}

\item{nc_nNet}{An integer value. The number of networks based on principal components regression to generate.}

\item{nc_nCells}{An integer value. The number of cells to subsample each time to generate a network.}

\item{nc_nComp}{An integer value. The number of principal components in PCA to generate the networks. Should be greater than 2 and lower than the total number of genes.}

\item{nc_scaleScores}{A boolean value (TRUE/FALSE), if TRUE, the weights will be normalized such that the maximum absolute value is 1.}

\item{nc_symmetric}{A boolean value (TRUE/FALSE), if TRUE, the weights matrix returned will be symmetric.}

\item{nc_q}{A decimal value between 0 and 1. Defines the cut-off threshold of top q\% relationships to be returned.}

\item{td_K}{An integer value. Defines the number of rank-one tensors used to approximate the data using CANDECOMP/PARAFAC (CP) Tensor Decomposition.}

\item{td_maxIter}{An integer value. Defines the maximum number of iterations if error stay above \code{td_maxError}.}

\item{td_maxError}{A decimal value between 0 and 1. Defines the relative Frobenius norm error tolerance.}

\item{td_nDecimal}{An integer value indicating the number of decimal places to be used.}

\item{ma_nDim}{An integer value. Defines the number of dimensions of the low-dimensional feature space to be returned from the non-linear manifold alignment.}

\item{nCores}{An integer value. Defines the number of cores to be used.}
}
\description{
Predict gene perturbations
}
\examples{
# Loading single-cell data
scRNAseq <- system.file("single-cell/example.csv", package = "scTenifoldKnk")
scRNAseq <- read.csv(scRNAseq, row.names = 1)

# Running scTenifoldKnk
scTenifoldKnk(countMatrix = scRNAseq, gKO = "G100", qc_minLSize = 0)
}
\author{
Daniel Osorio <dcosorioh@tamu.edu>
}
