% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code-to-term.R
\name{clst_term_to_code}
\alias{clst_term_to_code}
\title{SDTM code list term to respective code}
\usage{
clst_term_to_code(term)
}
\arguments{
\item{term}{A SDTM controlled terminology term referring to a codelist.}
}
\value{
A character vector of SDTM codes for codelists. The number
of elements returned matches the number of elements in \code{term}, i.e. there
is a one-to-one correspondence between input and output. Invalid codes in
\code{term} are mapped to \code{NA}.
}
\description{
\code{\link[=clst_term_to_code]{clst_term_to_code()}} maps SDTM terminology codelists' terms to respective
C-codes. For mapping terms other than those representing codelists, use
\code{\link[=term_to_code]{term_to_code()}} instead.
}
\examples{
clst_term_to_code(term = "SEX")

# `term` is vectorized.
clst_term_to_code(term = c("SEX", "SIZE"))

# Invalid codes (e.g. `"YODA"`) map to `NA`.
clst_term_to_code(term = c("SEX", "SIZE", "YODA"))

}
\seealso{
See \code{\link[=clst_code_to_term]{clst_code_to_term()}} for the inverse operation.
}
