% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miPowerFit.R
\name{epcEquivFit}
\alias{epcEquivFit}
\alias{miPowerFit}
\alias{summary.epcequivfit.data.frame}
\title{EPC Equivalence Fit Evaluation Using Modification Indices}
\usage{
epcEquivFit(lavaanObj, stdLoad = 0.4, cor = 0.1, corLatent = NULL,
  corResidual = NULL, stdBeta = 0.1, stdIntcept = 0.2, stdSesoi = NULL,
  sesoi = NULL, cilevel = 0.9, ...)

\method{summary}{epcequivfit.data.frame}(object, ..., top = 5, ssv = FALSE)
}
\arguments{
\item{lavaanObj}{A fitted \code{lavaan} object used to evaluate model fit.}

\item{stdLoad}{Standardized factor loading defining the SESOI for
loading misspecifications. Default is 0.4.}

\item{cor}{Default standardized correlation defining the SESOI for
covariance misspecifications. Used for both latent and residual
covariances unless overridden.}

\item{corLatent}{Standardized latent factor correlation defining the
SESOI for latent covariance misspecifications. If \code{NULL},
defaults to \code{cor}.}

\item{corResidual}{Standardized residual correlation defining the
SESOI for residual covariance misspecifications. If \code{NULL},
defaults to \code{cor}.}

\item{stdBeta}{Standardized regression coefficient defining the SESOI
for structural misspecifications. Default is 0.1.}

\item{stdIntcept}{Standardized intercept (Cohen's \emph{d}) defining
the SESOI for intercept misspecifications. Default is 0.2.}

\item{stdSesoi}{Optional vector of standardized SESOI values. If
provided, overrides operator-specific SESOI definitions.}

\item{sesoi}{Optional vector of unstandardized SESOI values. If
provided, overrides \code{stdSesoi} and all operator-specific SESOI
arguments.}

\item{cilevel}{Confidence level for EPC confidence intervals used in
CI-based equivalence testing.}

\item{\dots}{Additional arguments passed to
\code{\link[lavaan]{modificationIndices}}.}

\item{object}{An object returned by \code{\link{epcEquivFit}}.}

\item{top}{Number of top-ranked EPCs to display.}

\item{ssv}{Logical; whether to include power-based diagnostics.}
}
\value{
A data frame with one row per fixed parameter, containing:
\enumerate{
\item Parameter identifiers: \code{lhs}, \code{op}, \code{rhs}, and \code{group}.
\item Modification index (\code{mi}) and expected parameter change estimates
(\code{epc}).
\item Unstandardized and standardized smallest effect size of interest values
(\code{sesoi}, \code{std.sesoi}).
\item Power-based decision (\code{decision.pow}) and related diagnostics, including
whether the modification index is statistically significant
(\code{significant.mi}) and whether the misfit at the SESOI has power greater
than 0.80 (\code{high.power}). Decision labels are:
M = Substantially Misspecified,
I = Inconclusive,
NM = Trivially Misspecified,
EPC:M = Substantially Misspecified based on EPC information,
EPC:NM = Trivially Misspecified based on EPC information.
\item EPC-related statistics, including the standard error of the EPC
(\code{se.epc}), confidence interval bounds for the EPC
(\code{lower.epc}, \code{upper.epc}), and confidence interval bounds for the
standardized EPC (\code{lower.std.epc}, \code{upper.std.epc}).
\item Confidence-interval–based equivalence decision (\code{decision.ci}), with
labels:
M = Substantially Misspecified (EPC exceeds the SESOI),
I = Inconclusive,
NM = Trivially Misspecified,
U = Underpowered (CI too wide to evaluate equivalence relative to the SESOI).
}
}
\description{
Evaluates model fit from an equivalence-testing perspective by
aggregating local EPC-based diagnostics into a global, fit-style
assessment. The procedure combines modification indices (MI),
expected parameter changes (EPC), statistical power, and confidence
intervals relative to a smallest effect size of interest (SESOI).
}
\details{
Two complementary local decision rules are implemented:

\strong{Method 1 (Power-based; Saris, Satorra, & van der Veld, 2009).}
Modification indices, statistical power, and EPC magnitude are jointly
evaluated (the J-rule) to classify fixed parameters as misspecified,
not misspecified, or inconclusive.

\strong{Method 2 (CI-based equivalence testing).}
Confidence intervals of EPCs are compared against a trivial
misspecification region defined by the SESOI to determine whether
fixed parameters are substantially misspecified, trivially misspecified,
underpowered, or inconclusive.

The resulting local classifications are returned in a single data
frame and can be summarized to yield a global equivalence-style fit
evaluation.

This function provides a local-to-global equivalence-based alternative
to traditional exact-fit evaluation. It is designed to assess whether
fixed parameters are substantively misspecified relative to a SESOI,
rather than whether a model fits exactly.

Models with categorical indicators or unsupported constraints may
not be fully supported.
}
\examples{

library(lavaan)

one.model <- ' onefactor  =~ x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8 + x9 '
fit <- cfa(one.model, data = HolzingerSwineford1939)
out <- epcEquivFit(fit)
out
summary(out)

}
\references{
Saris, W. E., Satorra, A., & van der Veld, W. M. (2009).
Testing structural equation models or detection of misspecifications?
\emph{Structural Equation Modeling, 16}(4), 561--582.
}
\seealso{
\code{\link{epcEquivCheck}}
}
