% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDiagnosis.R
\name{skew}
\alias{skew}
\title{Finding skewness}
\usage{
skew(object, population = FALSE)
}
\arguments{
\item{object}{A vector used to find a skewness}

\item{population}{\code{TRUE} to compute the parameter formula. \code{FALSE}
to compute the sample statistic formula.}
}
\value{
A value of a skewness with a test statistic if the population is
specified as \code{FALSE}
}
\description{
Finding skewness (\eqn{g_{1}}) of an object
}
\details{
The skewness computed by default is \eqn{g_{1}}, the third standardized
moment of the empirical distribution of \code{object}.
The population parameter skewness \eqn{\gamma_{1}} formula is

\deqn{\gamma_{1} = \frac{\mu_{3}}{\mu^{3/2}_{2}},}

where \eqn{\mu_{i}} denotes the \eqn{i} order central moment.

The skewness formula for sample statistic \eqn{g_{1}} is

\deqn{g_{1} = \frac{k_{3}}{k^{2}_{2}},}

where \eqn{k_{i}} are the \eqn{i} order \emph{k}-statistic.

The standard error of the skewness is

\deqn{Var(\hat{g}_1) = \frac{6}{N}}

where \eqn{N} is the sample size.
}
\examples{

skew(1:5)

}
\references{
Weisstein, Eric W. (n.d.). \emph{Skewness}. Retrieved from
\emph{MathWorld}--A Wolfram Web Resource:
\url{https://mathworld.wolfram.com/Skewness.html}
}
\seealso{
\itemize{
\item \code{\link[=kurtosis]{kurtosis()}} Find the univariate excessive kurtosis
of a variable
\item \code{\link[=mardiaSkew]{mardiaSkew()}} Find Mardia's multivariate skewness
of a set of variables
\item \code{\link[=mardiaKurtosis]{mardiaKurtosis()}} Find the Mardia's multivariate
kurtosis of a set of variables
}
}
\author{
Sunthud Pornprasertmanit (\email{psunthud@gmail.com})
}
