% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_custom_fields.R
\name{st_custom_fields_filter}
\alias{st_custom_fields_filter}
\title{Create a Custom Fields Filter}
\usage{
st_custom_fields_filter(
  custom_fields,
  auth_token = NULL,
  base_url = "https://api.sensortower.com"
)
}
\arguments{
\item{custom_fields}{List. A list of custom field criteria with the following structure:
- exclude: Logical. Whether to exclude apps matching this criteria
- global: Logical. Whether this is a global field (TRUE) or organization field (FALSE)
- name: Character. The name of the custom field (e.g., "Free", "Release Date (US)")
- values: Character vector. Values to filter by (can be empty)
- true: Logical. For boolean fields, the value to match}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}

\item{base_url}{Optional. Character string. The base URL for the API.}
}
\value{
Character string containing the custom fields filter ID
}
\description{
Creates a custom fields filter ID by posting filter criteria to Sensor Tower.
This filter ID can then be used with other endpoints to query filtered data.
}
\examples{
\dontrun{
# Create a filter for free apps
filter_id <- st_custom_fields_filter(
  custom_fields = list(
    list(
      exclude = FALSE,
      global = TRUE,
      name = "Free",
      values = list(),
      true = TRUE
    )
  )
)
}

}
