% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentometrics.R
\docType{data}
\name{usnews}
\alias{usnews}
\title{Texts (not) relevant to the U.S. economy}
\format{
A \code{data.frame}, formatted as required to be an input for \code{\link{sento_corpus}}.
}
\source{
\strong{Economic News Article Tone and Relevance} dataset. Retrieved
November 1, 2017.
}
\usage{
data("usnews")
}
\description{
A collection of texts annotated by humans in terms of relevance to the U.S. economy or not. The texts come from two major
journals in the U.S. (The Wall Street Journal and The Washington Post) and cover 4145 documents between 1995 and 2014. It
contains following information:

\itemize{
  \item id. A \code{character} ID identifier.
  \item date. Date as \code{"yyyy-mm-dd"}.
  \item texts. Texts in \code{character} format.
  \item wsj. Equals 1 if the article comes from The Wall Street Journal.
  \item wapo. Equals 1 if the article comes from The Washington Post (complementary to `wsj').
  \item economy. Equals 1 if the article is relevant to the U.S. economy.
  \item noneconomy. Equals 1 if the article is not relevant to the U.S. economy (complementary to `economy').
}
}
\examples{
data("usnews", package = "sentometrics")
usnews[3192, "texts"]
usnews[1:5, c("id", "date", "texts")]

}
\keyword{datasets}
