% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.seroincidence.by.R
\name{print.summary.seroincidence.by}
\alias{print.summary.seroincidence.by}
\title{Print Method for Seroincidence Summary Object}
\usage{
\method{print}{summary.seroincidence.by}(x, ...)
}
\arguments{
\item{x}{A "summary.seroincidence.by" object
(constructed by \code{\link[=summary.seroincidence.by]{summary.seroincidence.by()}})}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
an \link{invisible} copy of input parameter \code{x}
}
\description{
Custom \code{\link[=print]{print()}} function for "summary.seroincidence.by" objects
(constructed by \code{\link[=summary.seroincidence.by]{summary.seroincidence.by()}})
}
\examples{
library(dplyr)

xs_data <-
  sees_pop_data_pk_100

curve <-
  typhoid_curves_nostrat_100 |>
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG"))

noise <-
  example_noise_params_pk

# estimate seroincidence
est2 <- est_seroincidence_by(
  strata = c("catchment"),
  pop_data = xs_data,
  sr_params = curve,
  noise_params = noise,
  antigen_isos = c("HlyE_IgG", "HlyE_IgA"),
  # num_cores = 8 # Allow for parallel processing to decrease run time
)

# calculate summary statistics for the seroincidence object
est2_summary <- summary(est2)
print(est2_summary)

}
\keyword{internal}
