% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-billing_groups.R
\name{Billing_groups}
\alias{Billing_groups}
\title{R6 Class representing billing groups endpoints}
\description{
R6 Class representing billing groups resource endpoints.
}
\examples{

## ------------------------------------------------
## Method `Billing_groups$query`
## ------------------------------------------------

\dontrun{
 billing_groups_object <- Billing_groups$new(
   auth = auth
 )

 # List all your billing groups
 billing_groups_object$query()
}


## ------------------------------------------------
## Method `Billing_groups$get`
## ------------------------------------------------

\dontrun{
 billing_groups_object <- Billing_groups$new(
   auth = auth
 )

 # Get single billing group
 billing_groups_object$get(id = id)
}

}
\section{Super class}{
\code{\link[sevenbridges2:Resource]{sevenbridges2::Resource}} -> \code{Billing_groups}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Billing_groups-new}{\code{Billing_groups$new()}}
\item \href{#method-Billing_groups-query}{\code{Billing_groups$query()}}
\item \href{#method-Billing_groups-get}{\code{Billing_groups$get()}}
\item \href{#method-Billing_groups-clone}{\code{Billing_groups$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sevenbridges2" data-topic="Resource" data-id="delete"><a href='../../sevenbridges2/html/Resource.html#method-Resource-delete'><code>sevenbridges2::Resource$delete()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Billing_groups-new"></a>}}
\if{latex}{\out{\hypertarget{method-Billing_groups-new}{}}}
\subsection{Method \code{new()}}{
Create a new Billing_groups object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Billing_groups$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Billing_groups-query"></a>}}
\if{latex}{\out{\hypertarget{method-Billing_groups-query}{}}}
\subsection{Method \code{query()}}{
List all your billing groups, including groups
that are pending or have been disabled.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Billing_groups$query(
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like query parameters, 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{Billing}} groups.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 billing_groups_object <- Billing_groups$new(
   auth = auth
 )

 # List all your billing groups
 billing_groups_object$query()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Billing_groups-get"></a>}}
\if{latex}{\out{\hypertarget{method-Billing_groups-get}{}}}
\subsection{Method \code{get()}}{
Retrieve a single billing group, specified by its ID.
To find the \code{billing_group}, use the call \code{Billing_groups$query()}
to list all your billing groups. The information returned
includes the billing group owner, the total balance, and the status of
the billing group (pending or confirmed).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Billing_groups$get(id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The ID of the billing group you are querying.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Billing}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 billing_groups_object <- Billing_groups$new(
   auth = auth
 )

 # Get single billing group
 billing_groups_object$get(id = id)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Billing_groups-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Billing_groups-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Billing_groups$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
