% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/doc.R
\name{chip}
\alias{chip}
\title{chip}
\usage{
chip(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI chip component.
}
\description{
A Chip is a small block of essential information that represent an input, attribute, or action.
}
\details{
\itemize{
\item \bold{children}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{variant}. Type: \code{solid OR bordered OR light OR flat OR faded OR shadow OR dot}. Default: \code{"solid"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"default"}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{"full"}.
\item \bold{avatar}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{startContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{endContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<"base" OR "content" OR "dot" OR "avatar" OR "closeButton", string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onClose}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  div(
    class = "flex gap-2 my-2",
    chip(
      id = "plop",
      "A chip",
      onClose = JS("(e) => {
        var chipEl = e.target.offsetParent;
        Shiny.setInputValue(chipEl.id, false);
        $(chipEl).remove();
      }")
    ),
    chip(
      "A chip",
      color = "success",
      size = "lg",
      radius = "sm",
      variant = "flat",
      startContent = icon("home"),
      endContent = icon("bell")
    ),
    chip(
      avatar = avatar(name = "JW", src = "https://i.pravatar.cc/300?u=a042581f4e29026709d"),
      "hello"
    ),
    reactOutput("modal")
  )
)

server <- function(input, output, session) {

  modalVisible <- reactiveVal(FALSE)
  observeEvent({
    input$plop
  }, {
    if (!input$plop) modalVisible(TRUE)
  })

  observeEvent(input$modal_closed, {
    modalVisible(FALSE)
  })

  output$modal <- renderReact({
    modal(
      scrollBehavior = input$scroll,
      isOpen = modalVisible(),
      size = "sm",
      placement = "top",
      modal_content(
        modal_header("Congrats"),
        modal_body(
          p("You closed me!")
        )
      ),
      onClose = JS("() => Shiny.setInputValue('modal_closed', true, {priority: 'event'})")
    )
  })
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/chip}.
}
