% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/doc.R
\name{circular_progress}
\alias{circular_progress}
\alias{circular-progress}
\title{circular-progress}
\usage{
circular_progress(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI circular-progress component.
}
\description{
Circular progress indicators are utilized to indicate an undetermined wait period or visually represent the duration of a process.
}
\details{
\itemize{
\item \bold{label}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"primary"}.
\item \bold{value}. Type: \code{number}. Default: \code{NA}.
\item \bold{valueLabel}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{minValue}. Type: \code{number}. Default: \code{"0"}.
\item \bold{maxValue}. Type: \code{number}. Default: \code{"100"}.
\item \bold{formatOptions}. Type: \code{Intl.NumberFormat}. Default: \code{"{style: 'percent'}"}.
\item \bold{isIndeterminate}. Type: \code{boolean}. Default: \code{true}.
\item \bold{showValueLabel}. Type: \code{boolean}. Default: \code{true}.
\item \bold{strokeWidth}. Type: \code{number}. Default: \code{"2"}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<'base'OR'svgWrapper'OR'svg'OR'track'OR'indicator'OR'value'OR'label', string>>}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)

ui <- nextui_page(
  dark_mode = TRUE,
  div(
    class = "flex gap-4",
    card(
      class = "",
      card_body(
        class = "grid grid-cols-2 gap-4",
        circular_progress(
          value = 3,
          showValueLabel = TRUE,
          strokeWidth = 4,
          size = "lg",
          minValue = 0,
          maxValue = 150,
          valueLabel = div(icon("battery-full", class = "mx-1"), "2\%"),
          color = "danger"
        ),
        circular_progress(
          value = 120,
          showValueLabel = TRUE,
          strokeWidth = 4,
          size = "lg",
          minValue = 0,
          maxValue = 150,
          valueLabel = div(icon("mobile-screen-button", class = "mx-1"), "80\%"),
          color = "success"
        )
      )
    )
  )
)

server <- function(input, output, session) {

}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/circular-progress}.
}
