% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/feedback.R
\name{drawer}
\alias{drawer}
\alias{drawer_content}
\alias{drawer_header}
\alias{drawer_body}
\alias{drawer_footer}
\title{drawer}
\usage{
drawer(...)

drawer_content(...)

drawer_header(...)

drawer_body(...)

drawer_footer(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI drawer component.
}
\description{
Displays a panel that slides in from the edge of the screen, containing supplementary content.
}
\details{
\itemize{
\item \bold{children}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{size}. Type: \code{xs OR sm OR md OR lg OR xl OR 2xl OR 3xl OR 4xl OR 5xl OR full}. Default: \code{"md"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg}. Default: \code{"lg"}.
\item \bold{placement}. Type: \code{left OR right OR top OR bottom}. Default: \code{"right"}.
\item \bold{isOpen}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{defaultOpen}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{isDismissable}. Type: \code{boolean}. Default: \code{true}.
\item \bold{isKeyboardDismissDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{shouldBlockScroll}. Type: \code{boolean}. Default: \code{true}.
\item \bold{hideCloseButton}. Type: \code{boolean}. Default: \code{false}.
\item \bold{closeButton}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{motionProps}. Type: \code{MotionProps}. Default: \code{NA}.
\item \bold{portalContainer}. Type: \code{HTMLElement}. Default: \code{"document.body"}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<'wrapper' OR 'base' OR 'backdrop' OR 'header' OR 'body' OR 'footer' OR 'closeButton', string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onOpenChange}. Type: \code{(isOpen: boolean) => void}. Default: \code{NA}.
\item \bold{onClose}. Type: \code{() => void}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  action_button(
    inputId = "show_drawer",
    color = "primary",
    shadow = TRUE,
    "Show drawer"
  ),
  reactOutput("drawer")
)

server <- function(input, output, session) {
  drawerVisible <- reactiveVal(FALSE)
  observeEvent(input$show_drawer, {
    drawerVisible(TRUE)
  })

  observeEvent(input$hide_drawer, {
    drawerVisible(FALSE)
  })

  observeEvent(input$drawer_closed, {
    drawerVisible(FALSE)
  })

  output$drawer <- renderReact({
    drawer(
      scrollBehavior = input$scroll,
      isOpen = drawerVisible(),
      size = "sm",
      backdrop = "transparent",
      placement = "right",
      motionProps = JS(
        "{
          variants: {
            enter: {
              opacity: 1,
              x: 0,
              duration: 10,
            },
            exit: {
              x: 100,
              opacity: 0,
              duration: 10,
            },
          },
        }"
      ),
      drawer_content(
        drawer_header("My drawer"),
        drawer_body(
          p(
            "Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
            dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
            ac consectetur ac, vestibulum at eros."
          ),
          p(
            "Lorem ipsum dolor sit amet, consectetur adipiscing elit.
            Nullam pulvinar risus non risus hendrerit venenatis.
            Pellentesque sit amet hendrerit risus, sed porttitor quam.
            Magna exercitation reprehenderit magna aute tempor cupidatat
            consequat elit dolor adipisicing. Mollit dolor eiusmod sunt ex
            incididunt cillum quis. Velit duis sit officia eiusmod Lorem
            aliqua enim laboris do dolor eiusmod. Et mollit incididunt
            nisi consectetur esse laborum eiusmod pariatur proident Lorem
            eiusmod et. Culpa deserunt nostrud ad veniam."
          ),
          p(
            "Mollit dolor eiusmod sunt ex incididunt cillum quis. Velit
             duis sit officia eiusmod Lorem aliqua enim laboris do dolor
             eiusmod. Et mollit incididunt nisi consectetur esse laborum
             eiusmod pariatur proident Lorem eiusmod et. Culpa deserunt
             nostrud ad veniam. Lorem ipsum dolor sit amet, consectetur
             adipiscing elit. Nullam pulvinar risus non risus hendrerit
             venenatis. Pellentesque sit amet hendrerit risus, sed
             porttitor quam. Magna exercitation reprehenderit magna aute
             tempor cupidatat consequat elit dolor adipisicing. Mollit
             dolor eiusmod sunt ex incididunt cillum quis. Velit duis sit
             officia eiusmod Lorem aliqua enim laboris do dolor eiusmod. Et
             mollit incididunt nisi consectetur esse laborum eiusmod
             pariatur proident Lorem eiusmod et. Culpa deserunt nostrud ad
             veniam."
          ),
          p(
            "Mollit dolor eiusmod sunt ex incididunt cillum quis. Velit
             duis sit officia eiusmod Lorem aliqua enim laboris do dolor
             eiusmod. Et mollit incididunt nisi consectetur esse laborum
             eiusmod pariatur proident Lorem eiusmod et. Culpa deserunt
             nostrud ad veniam. Lorem ipsum dolor sit amet, consectetur
             adipiscing elit. Nullam pulvinar risus non risus hendrerit
             venenatis. Pellentesque sit amet hendrerit risus, sed
             porttitor quam. Magna exercitation reprehenderit magna aute
             tempor cupidatat consequat elit dolor adipisicing. Mollit
             dolor eiusmod sunt ex incididunt cillum quis. Velit duis sit
             officia eiusmod Lorem aliqua enim laboris do dolor eiusmod. Et
             mollit incididunt nisi consectetur esse laborum eiusmod
             pariatur proident Lorem eiusmod et. Culpa deserunt nostrud ad
             veniam."
          )
        ),
        drawer_footer(
          action_button(
            inputId = "hide_drawer",
            color = "danger",
            shadow = TRUE,
            "Close drawer"
          )
        )
      ),
      onClose = JS(
        "() => Shiny.setInputValue('drawer_closed', true, {priority: 'event'})"
      )
    )
  })

  exportTestValues(
    drawer_state = drawerVisible()
  )
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/drawer}.
}
