% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.shrinkGPR_marg_samples_1D}
\alias{plot.shrinkGPR_marg_samples_1D}
\title{Plot method for 1D marginal predictions}
\usage{
\method{plot}{shrinkGPR_marg_samples_1D}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"shrinkGPR_marg_samples_1D"}, typically returned by
\code{\link{gen_marginal_samples}} when providing a single covariate to sweep over.}

\item{...}{Additional arguments passed to \link[shrinkTVP]{plot.mcmc.tvp} for customizing the plot,
such as axis labels or plotting options.}
}
\value{
Called for its side effects. Returns \code{invisible(NULL)}.
}
\description{
Generates a plot of 1D conditional predictive samples produced by \code{\link{gen_marginal_samples}}
with a single covariate.
}
\details{
By default, the function visualizes the posterior predictive median and 95\% and 50\% credible intervals
for the selected covariate across a grid of evaluation points.
Axis labels are automatically inferred if not explicitly provided.

Note: The \pkg{shrinkTVP} package must be installed to use this function.
}
\examples{
\donttest{
# Simulate data
set.seed(123)
torch::torch_manual_seed(123)
n <- 100
x <- matrix(runif(n * 2), n, 2)
y <- sin(2 * pi * x[, 1]) + rnorm(n, sd = 0.1)
data <- data.frame(y = y, x1 = x[, 1], x2 = x[, 2])

# Fit GPR model
res <- shrinkGPR(y ~ x1 + x2, data = data)

# Generate marginal samples
marginal_samps_x1 <- gen_marginal_samples(res, to_eval = "x1", nsamp = 100)
marginal_samps_x2 <- gen_marginal_samples(res, to_eval = "x2", nsamp = 100)

# Plot marginal predictions
plot(marginal_samps_x1)
plot(marginal_samps_x2)

# Customize plot appearance (see plot.mcmc.tvp from shrinkTVP package for more options)
plot(marginal_samps_x2, shaded = FALSE, quantlines = TRUE, quantcol = "red")
}

}
\seealso{
\code{\link{gen_marginal_samples}}

Other plotting functions: 
\code{\link{plot.shrinkGPR}()},
\code{\link{plot.shrinkGPR_marg_samples_2D}()},
\code{\link{plot.shrinkTPR}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{plotting functions}
