% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated-funs.R
\name{silv_ntrees_ha}
\alias{silv_ntrees_ha}
\title{Calculates number of trees per hectare}
\usage{
silv_ntrees_ha(ntrees, plot_size, plot_shape = "circular")
}
\arguments{
\item{ntrees}{A numeric vector representing the number of trees in a sampling plot}

\item{plot_size}{A numeric vector of length one for circular radius in meters;
or a numeric vector of length two for each side of a rectangular plot shape}

\item{plot_shape}{The shape of the sampling plot. Either \code{circular} or \code{rectangular}}
}
\value{
A numeric vector
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Calculates number of trees per hectare for a given plot size and shape
}
\examples{
library(dplyr)
## Circular plot of 10 meters radius
inventory_samples |>
  count(plot_id, species) |>
  mutate(
    ntrees_ha = silv_ntrees_ha(n, plot_size = 10)
  )

## Rectangular plot of 10x15 meters
inventory_samples |>
  count(plot_id, species) |>
  mutate(
    ntrees_ha = silv_ntrees_ha(
      n,
      plot_size = c(10, 15),
      plot_shape = "rectangular"
     )
  )
}
