% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_colors.R
\name{sits_colors}
\alias{sits_colors}
\title{Function to retrieve sits color table}
\usage{
sits_colors(legend = NULL)
}
\arguments{
\item{legend}{One of the accepted legends in sits}
}
\value{
A tibble with color names and values
}
\description{
Returns the default color table.
}
\note{
SITS has a predefined color palette with 238 class names.
These colors are grouped by typical legends used by the Earth observation
community, which include “IGBP”, “UMD”, “ESA_CCI_LC”, and “WORLDCOVER”.
Use \code{\link[sits]{sits_colors_show}} to see a specific palette.
The default color table can be extended using
\code{\link[sits]{sits_colors_set}}.
}
\examples{
if (sits_run_examples()) {
    # return the names of all colors supported by SITS
    sits_colors()
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
