% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.variance_cube}
\alias{plot.variance_cube}
\title{Plot variance cubes}
\usage{
\method{plot}{variance_cube}(
  x,
  ...,
  tile = x[["tile"]][[1L]],
  roi = NULL,
  labels = NULL,
  palette = "YlGnBu",
  rev = FALSE,
  type = "map",
  quantile = 0.75,
  scale = 1,
  max_cog_size = 1024L,
  legend_position = "inside",
  legend_title = "logvar"
)
}
\arguments{
\item{x}{Object of class "variance_cube".}

\item{...}{Further specifications for \link{plot}.}

\item{tile}{Tile to be plotted.}

\item{roi}{Spatial extent to plot (see notes)}

\item{labels}{Labels to plot.}

\item{palette}{RColorBrewer or "cols4all" palette}

\item{rev}{Reverse order of colors in palette?}

\item{type}{Type of plot ("map" or "hist")}

\item{quantile}{Minimum quantile to plot}

\item{scale}{Scale to plot map (0.4 to 1.0)}

\item{max_cog_size}{Maximum size of COG overviews (lines or columns)}

\item{legend_position}{Where to place the legend (default = "inside")}

\item{legend_title}{Title of legend (default = "probs")}
}
\value{
A plot containing local variances associated to the
                       logit probability for each pixel and each class.
}
\description{
Plots a variance cube, useful to understand how local
smoothing will work.
}
\note{
To see which color palettes are supported, please run cols4all::c4a_gui().
To define a \code{roi} use one of:
     \itemize{
       \item{A path to a shapefile with polygons;}
       \item{A \code{sfc} or \code{sf} object from \code{sf} package;}
       \item{A \code{SpatExtent} object from \code{terra} package;}
       \item{A named \code{vector} (\code{"lon_min"},
            \code{"lat_min"}, \code{"lon_max"}, \code{"lat_max"}) in WGS84;}
       \item{A named \code{vector} (\code{"xmin"}, \code{"xmax"},
             \code{"ymin"}, \code{"ymax"}) with XY coordinates.}
}
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # obtain a variance cube
    var_cube <- sits_variance(probs_cube, output_dir = tempdir())
    # plot the variance cube
    plot(var_cube)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
