% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiview.R
\name{multiview}
\alias{multiview}
\alias{multiview,sf-method}
\alias{multiview,SpatRaster-method}
\title{multiview embedding forecast}
\usage{
\S4method{multiview}{sf}(
  data,
  column,
  target,
  nvar,
  E = 3,
  k = E + 2,
  tau = 1,
  style = 1,
  stack = FALSE,
  lib = NULL,
  pred = NULL,
  dist.metric = "L2",
  dist.average = TRUE,
  top = NULL,
  threads = detectThreads(),
  detrend = TRUE,
  nb = NULL
)

\S4method{multiview}{SpatRaster}(
  data,
  column,
  target,
  nvar,
  E = 3,
  k = E + 2,
  tau = 1,
  style = 1,
  stack = FALSE,
  lib = NULL,
  pred = NULL,
  dist.metric = "L2",
  dist.average = TRUE,
  top = NULL,
  threads = detectThreads(),
  detrend = TRUE,
  grid.coord = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{column}{name of library variable.}

\item{target}{name of target variable.}

\item{nvar}{number of variable combinations.}

\item{E}{(optional) embedding dimensions.}

\item{k}{(optional) number of nearest neighbors used.}

\item{tau}{(optional) step of spatial lags.}

\item{style}{(optional) embedding style (\code{0} includes current state, \code{1} excludes it).}

\item{stack}{(optional) whether to stack embeddings.}

\item{lib}{(optional) libraries indices (input needed: \code{vector} - spatial vector, \code{matrix} - spatial raster).}

\item{pred}{(optional) predictions indices (input requirement same as \code{lib}).}

\item{dist.metric}{(optional) distance metric (\code{L1}: Manhattan, \code{L2}: Euclidean).}

\item{dist.average}{(optional) whether to average distance.}

\item{top}{(optional) number of reconstructions used in MVE forecast.}

\item{threads}{(optional) number of threads to use.}

\item{detrend}{(optional) whether to remove the linear trend.}

\item{nb}{(optional) neighbours list.}

\item{grid.coord}{(optional) whether to detrend using cell center coordinates (\code{TRUE}) or row/column numbers (\code{FALSE}).}
}
\value{
A vector (when input is sf object) or matrix
}
\description{
multiview embedding forecast
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg",package="spEDM"))
\donttest{
multiview(columbus,
          column = c("inc","crime","open","plumb","discbd"),
          target = "hoval", nvar = 3)
}
}
\references{
Ye H., and G. Sugihara, 2016. Information leverage in interconnected ecosystems: Overcoming the curse of dimensionality. Science 353:922-925.
}
