#' This class represents a list of values.
#'
#' Used to define a list of ExprValue instances for the INSERT query.
#'
#' @examples
#' # To generate the list of values 1234, "The River", "1965":
#' ExprListValues$new(list(ExprValue$new(1234),
#'                         ExprValue$new("The River"),
#'                         ExprValue$new(1965)))
#'
#' @import R6
#' @include ExprList.R
#' @include TokenSymbol.R
#' @export
ExprListValues <- R6::R6Class("ExprListValues",
  inherit = ExprList,
  public = list(

    #' @description
    #' Initializer.
    #' @param values A list of ExprValue instances.
    #' @return Nothing.
    initialize = function(values) {
      chk::chk_all(values, chk::chk_is, "ExprValue")
      super$initialize(values)
      return(invisible(NULL))
    }
))
