% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.bayes.normal}
\alias{ci.bayes.normal}
\title{Bayesian credible interval for a normal prior distribution}
\usage{
ci.bayes.normal(alpha, prior_mean, prior_sd, est, se)
}
\arguments{
\item{alpha}{alpha level for 1-alpha credibility interval}

\item{prior_mean}{mean of prior Normal distribution}

\item{prior_sd}{standard deviation of prior Normal distribution}

\item{est}{sample estimate}

\item{se}{standard error of sample estimate}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Posterior mean - posterior mean of Normal distribution
\item Posterior SD - posterior standard deviation of Normal distribution
\item LL - lower limit of the credible interval
\item UL - upper limit of the credible interval
}
}
\description{
Computes an approximate Bayesian credible interval for a normal prior
distribution. This function can be used with any parameter estimator
(e.g., mean, mean difference, linear contrast of means, slope coefficient,
standardized mean difference, standardized linear contrast of means, median,
median difference, linear contrast of medians, etc.) that has an approximate
normal sampling distribution. The mean and standard deviation of the posterior
normal distribution are also reported.

For more details, see Section 1.32 of Bonett (2021, Volume 1)
}
\examples{
ci.bayes.normal(.05, 50, 5, 38.3, 2.57)

# Should return:
# Posterior mean Posterior SD       LL       UL
#       40.74511     2.285735 36.26515 45.22506


}
\references{
\insertRef{Gelman2004}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
