% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.prop2}
\alias{ci.prop2}
\title{Confidence interval for a 2-group proportion difference}
\usage{
ci.prop2(alpha, f1, f2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{number of participants in group 1 who have the attribute}

\item{f2}{number of participants in group 2 who have the attribute}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - adjusted estimate of proportion difference
\item SE - adjusted standard error
\item LL - lower limit of the adjusted Wald confidence interval
\item UL - upper limit of the adjusted Wald confidence interval
}
}
\description{
Computes an adjusted Wald confidence interval for a population proportion
difference in a 2-group design.

For more details, see Section 2.2 of Bonett (2021, Volume 3)
}
\examples{
ci.prop2(.05, 57, 15, 100, 100)

# Should return:
#   Estimate         SE        LL        UL
#  0.4117647 0.06083948 0.2925215 0.5310079


}
\references{
\insertRef{Agresti2000}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
