% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{test.mean}
\alias{test.mean}
\title{Hypothesis test for a mean}
\usage{
test.mean(m, sd, n, h)
}
\arguments{
\item{m}{estimated mean}

\item{sd}{estimated standard deviation}

\item{n}{sample size}

\item{h}{null hypothesis value of mean}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item t - t test statistic
\item df - degrees of freedom
\item p - two-sided p-value
}
}
\description{
Computes a one-sample t-test for a population mean using the estimated
mean, estimated standard deviation, sample size, and null hypothesis value.
Use the t.test function for raw data input. A confidence interval for a
population mean is a recommended supplement to the t-test (see \link[statpsych]{ci.mean}).

For more details, see Section 1.11 of Bonett (2021, Volume 1)
}
\examples{
test.mean(7.9, 3.05, 100, 7)

# Should return:
#        t df       p
#   2.9508 99 0.00396
 

}
\references{
\insertRef{Snedecor1980}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
