% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcf.R
\name{extract_parameter.bcfmodel}
\alias{extract_parameter.bcfmodel}
\title{Extract BCF Parameter Samples}
\usage{
\method{extract_parameter}{bcfmodel}(object, term)
}
\arguments{
\item{object}{Object of type \code{bcfmodel} containing draws of a BCF model and associated sampling outputs.}

\item{term}{Name of the parameter to extract (e.g., \code{"sigma2"}, \code{"y_hat_train"}, etc.)}
}
\value{
Array of parameter samples. If the underlying parameter is a scalar, this will be a vector of length \code{num_samples}.
If the underlying parameter is vector-valued, this will be (\code{parameter_dimension} x \code{num_samples}) matrix, and if the underlying
parameter is multidimensional, this will be an array of dimension (\code{parameter_dimension_1} x \code{parameter_dimension_2} x ... x \code{num_samples}).
}
\description{
Extract a vector, matrix or array of parameter samples from a BCF model by name.
Random effects are handled by a separate \code{getRandomEffectSamples} function due to the complexity of the random effects parameters.
If the requested model term is not found, an error is thrown.
The following conventions are used for parameter names:
\itemize{
\item Global error variance: \code{"sigma2"}, \code{"global_error_scale"}, \code{"sigma2_global"}
\item Prognostic forest leaf scale: \code{"sigma2_leaf_mu"}, \code{"leaf_scale_mu"}, \code{"mu_leaf_scale"}
\item Treatment effect forest leaf scale: \code{"sigma2_leaf_tau"}, \code{"leaf_scale_tau"}, \code{"tau_leaf_scale"}
\item Adaptive coding parameters: \code{"adaptive_coding"} (returns both the control and treated parameters jointly, with control in the first row and treated in the second row)
\item In-sample mean function predictions: \code{"y_hat_train"}
\item Test set mean function predictions: \code{"y_hat_test"}
\item In-sample treatment effect forest predictions: \code{"tau_hat_train"}
\item Test set treatment effect forest predictions: \code{"tau_hat_test"}
\item In-sample variance forest predictions: \code{"sigma2_x_train"}, \code{"var_x_train"}
\item Test set variance forest predictions: \code{"sigma2_x_test"}, \code{"var_x_test"}
}
}
\examples{
n <- 500
p <- 5
X <- matrix(runif(n*p), ncol = p)
mu_x <- (
    ((0 <= X[,1]) & (0.25 > X[,1])) * (-7.5) +
    ((0.25 <= X[,1]) & (0.5 > X[,1])) * (-2.5) +
    ((0.5 <= X[,1]) & (0.75 > X[,1])) * (2.5) +
    ((0.75 <= X[,1]) & (1 > X[,1])) * (7.5)
)
pi_x <- (
    ((0 <= X[,1]) & (0.25 > X[,1])) * (0.2) +
    ((0.25 <= X[,1]) & (0.5 > X[,1])) * (0.4) +
    ((0.5 <= X[,1]) & (0.75 > X[,1])) * (0.6) +
    ((0.75 <= X[,1]) & (1 > X[,1])) * (0.8)
)
tau_x <- (
    ((0 <= X[,2]) & (0.25 > X[,2])) * (0.5) +
    ((0.25 <= X[,2]) & (0.5 > X[,2])) * (1.0) +
    ((0.5 <= X[,2]) & (0.75 > X[,2])) * (1.5) +
    ((0.75 <= X[,2]) & (1 > X[,2])) * (2.0)
)
Z <- rbinom(n, 1, pi_x)
E_XZ <- mu_x + Z*tau_x
snr <- 3
rfx_group_ids <- rep(c(1,2), n \%/\% 2)
rfx_coefs <- matrix(c(-1, -1, 1, 1), nrow=2, byrow=TRUE)
rfx_basis <- cbind(1, runif(n, -1, 1))
rfx_term <- rowSums(rfx_coefs[rfx_group_ids,] * rfx_basis)
y <- E_XZ + rfx_term + rnorm(n, 0, 1)*(sd(E_XZ)/snr)
bcf_model <- bcf(X_train = X, y_train = y, Z_train = Z,
                 rfx_group_ids_train = rfx_group_ids,
                 rfx_basis_train = rfx_basis,
                 num_gfr = 10, num_burnin = 0, num_mcmc = 10)
sigma2_samples <- extract_parameter(bcf_model, "sigma2")
}
