% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subplot.R
\name{subplot}
\alias{subplot}
\title{Sub-community plot under each sub-environmental space K}
\usage{
subplot(
  subnic,
  main = NULL,
  sig = NULL,
  sig_thres = 0.05,
  xlab = NULL,
  ylab = NULL,
  col.axis = "azure3",
  lty.axis = 2,
  lwd.axis = 2,
  pch.SR.pos = 21,
  cex.SR.pos = 1,
  col.SR.pt = "black",
  col.SR.pos = "#ffa600",
  col.SR.lab = "black",
  cex.SR.lab = NA,
  fac.SR.lab = 1.2,
  border.E = "black",
  col.E = "#92c5de",
  lty.E = 1,
  lwd.E = 1,
  border.K = "black",
  col.K = "#2c7fb8",
  lty.K = 1,
  lwd.K = 1,
  col.arrow = "black",
  angle.arrow = 20,
  lwd.arrow = 2,
  length.arrow = 0.1,
  col.Gk.pos = "red",
  col.Gk.pt = "black",
  cex.Gk.pos = 1,
  pch.Gk.pos = 21,
  col.su = "#b35806",
  pt.su = "black",
  cex.su = 0.7,
  pch.su = 1,
  font.sp = 2,
  leg = TRUE,
  posi.leg = "topleft",
  bty.leg = "n",
  ...
)
}
\arguments{
\item{subnic}{an object of class \code{subniche}.}

\item{main}{a main title for the plot, see \link[graphics]{title} for more details.}

\item{sig}{a factor defining the significance species, default NULL.}

\item{sig_thres}{value for minimum significance, default 0.05}

\item{xlab}{a label for the x axis, defaults to a description of x, see \link[graphics]{title} for more details.}

\item{ylab}{a label for the y axis, defaults to a description of y, see \link[graphics]{title} for more details.}

\item{col.axis}{axis color, see \link[graphics]{par} for more details.}

\item{lty.axis}{axis line type, see \link[graphics]{par} for more details.}

\item{lwd.axis}{axis width, see \link[graphics]{par} for more details.}

\item{pch.SR.pos}{type of the point representing SR position, see \link[graphics]{points} for more details.}

\item{cex.SR.pos}{size of the point representing SR position, see \link[graphics]{points} for more details.}

\item{col.SR.pt}{point color contour if pch=21:25.}

\item{col.SR.pos}{color of the point representing SR position, see \link[graphics]{points} for more details.}

\item{col.SR.lab}{color of the species labels, see see \link[graphics]{text} for more details.}

\item{cex.SR.lab}{size of the species labels defautls NA for no labels, see see \link[graphics]{text} for more details.}

\item{fac.SR.lab}{factor for moving the SR labels from its original coordinates for clarity, by defaults they are multiply 1.2}

\item{border.E}{color border of E polygon, see \link[graphics]{polygon} for more details.}

\item{col.E}{inside color of E polygon, see \link[graphics]{polygon} for more details.}

\item{lty.E}{line type for the E border, see \link[graphics]{polygon} for more details.}

\item{lwd.E}{line width for the E border, see \link[graphics]{polygon} for more details.}

\item{border.K}{color border of K polygon, see \link[graphics]{polygon} for more details.}

\item{col.K}{inside color of K polygon, see \link[graphics]{polygon} for more details.}

\item{lty.K}{line type for the K border, see \link[graphics]{polygon} for more details.}

\item{lwd.K}{line width for the K border, see \link[graphics]{polygon} for more details.}

\item{col.arrow}{arrow color, see \link[graphics]{arrows} for more details.}

\item{angle.arrow}{arrow angle head, see \link[graphics]{arrows} for more details.}

\item{lwd.arrow}{arrow width, see \link[graphics]{arrows} for more details.}

\item{length.arrow}{arrow head length, see \link[graphics]{arrows} for more details.}

\item{col.Gk.pos}{color of the point representing Gk, see \link[graphics]{points} for more details.}

\item{col.Gk.pt}{point color contour if pch=21:25.}

\item{cex.Gk.pos}{size of the point representing Gk, see \link[graphics]{points} for more details.}

\item{pch.Gk.pos}{type of the point representing Gk, see \link[graphics]{points} for more details.}

\item{col.su}{color of the points representing the sampling units (SU), see \link[graphics]{points} for more details.}

\item{pt.su}{point color contour if pch=21:25.}

\item{cex.su}{size of the points representing the sampling units (SU), see \link[graphics]{points} for more details.}

\item{pch.su}{type of the points representing the sampling units (SU), see \link[graphics]{points} for more details.}

\item{font.sp}{font of the species labels, see see \link[graphics]{text} for more details.}

\item{leg}{a logical option for legend to be plotted or not, default leg=TRUE.}

\item{posi.leg}{legend location in the graph, see \link[graphics]{legend} for more details.}

\item{bty.leg}{the type of box to be drawn around the legends. The allowed values are "o" (the default) and "n". See \link[graphics]{legend} for more details}

\item{...}{further arguments passed to or from other methods.}
}
\description{
The function to represent the community subniche position under each subenvironment K with their respective marginality from Gk.
}
\examples{
library(subniche)
library(ade4)
data(doubs)
dudi1 <- dudi.pca(doubs$env, scale = TRUE, scan = FALSE, nf = 3)
nic1 <- niche(dudi1, doubs$fish, scann = FALSE)
# number of sites
N <- dim(nic1$ls)[1]
#Create a factor which defines the subsets
fact <- factor(c(rep(1,N/2),rep(2,N/2)))
# nic1 will be use as reference and fact will be use to define the subniches environment
subnic1 <- subniche(nic1, fact)
#Two graphs are drawn one after the other
siggk <- rtestsubor(subnic1,10)
sig = c(siggk$`1`$witomigktest$subni.pvalue[-28],siggk$`2`$witomigktest$subni.pvalue[-28])
subplot(subnic1, sig = sig, sig_thres= 0.1)

}
