% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{cv_survdnn}
\alias{cv_survdnn}
\title{K-Fold Cross-Validation for survdnn Models}
\usage{
cv_survdnn(
  formula,
  data,
  times,
  metrics = c("cindex", "ibs"),
  folds = 5,
  .seed = NULL,
  .device = c("auto", "cpu", "cuda"),
  na_action = c("omit", "fail"),
  ...
)
}
\arguments{
\item{formula}{A survival formula, e.g., `Surv(time, status) ~ x1 + x2`.}

\item{data}{A data frame.}

\item{times}{A numeric vector of evaluation time points.}

\item{metrics}{A character vector: any of `"cindex"`, `"brier"`, `"ibs"`.}

\item{folds}{Integer. Number of folds to use.}

\item{.seed}{Optional. Set random seed for reproducibility.}

\item{.device}{Character string indicating the computation device used when fitting the models
in each fold. One of `"auto"`, `"cpu"`, or `"cuda"`. `"auto"` uses CUDA if available,
otherwise falls back to CPU.}

\item{na_action}{Character. How to handle missing values within each fold:
`"omit"` drops incomplete rows; `"fail"` errors if any NA is present.}

\item{...}{Additional arguments passed to [survdnn()].}
}
\value{
A tibble containing metric values per fold and (optionally) per time point.
}
\description{
Performs cross-validation for a `survdnn` model using the specified evaluation metrics.
}
\examples{
\donttest{
library(survival)
data(veteran)
cv_survdnn(
  Surv(time, status) ~ age + karno + celltype,
  data = veteran,
  times = c(30, 90, 180),
  metrics = "ibs",
  folds = 3,
  .seed = 42,
  hidden = c(16, 8),
  epochs = 5
)
}
}
