% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cml_power.R
\name{cml_power}
\alias{cml_power}
\alias{p_curve}
\alias{p_ncurve}
\title{Power and Power Curve Functions}
\usage{
cml_power(obj, effect = 0.03, alpha = 0.05, n = "auto", df = "auto")

p_curve(obj, alpha = 0.05, n = 300, df = "auto", from = 0, to = 0.2, ...)

p_ncurve(
  obj,
  effect = 0.03,
  alpha = 0.05,
  df = "auto",
  from = 0,
  to = 600,
  ...
)
}
\arguments{
\item{obj}{An object of class 'tcl_sa_size', typically containing information such as degrees of freedom (\code{df}) and
informative sample size (\code{n}). If missing, values for \code{df} and \code{n} need to be set manually.}

\item{effect}{Numeric value representing the effect size. A real number between 0 and 1, interpreted as a proportion of
pseudo-variance between persons with different covariate values (but the same person parameter). Default is 0.03.}

\item{alpha}{Type I error probability. Default is 0.05.}

\item{n}{Informative sample size (excluding persons with a score of 0 or highest possible score).
Default is \code{"auto"}, in which case the value is extracted from \code{obj}.}

\item{df}{Degrees of freedom. Default is \code{"auto"}, in which case the value is extracted from \code{obj}.}

\item{from}{Lower bound of the effect or sample size range (default is 0).}

\item{to}{Upper bound of the effect or sample size range (default is 0.2 for effect size, and 600 for sample site).}

\item{...}{Additional graphical arguments passed to \code{\link[graphics]{plot}} (e.g., \code{col}, \code{lwd}, \code{ylim}) via \code{\link{p_curve}} and \code{\link{p_ncurve}}.}
}
\value{
\itemize{
  \item \code{cml_power()}: Numeric vector of power values.
  \item \code{p_curve()}, \code{p_ncurve()}: A power curve plotted to the active graphics device.
}
}
\description{
Functions to compute the power of \eqn{\chi^2} tests, i.e., Wald (W), likelihood ratio (LR), Rao score (RS)
and gradient (GR) test, and to plot power curves as functions of effect size and sample size.

\code{cml_power()} computes the power of the tests given a specified effect size, type I error prob. alpha,
informative sample size, and degrees of freedom.

\code{p_curve()} generates a power curve as a function of effect size.

\code{p_ncurve()} generates a power curve as a function of sample size.
}
\details{
The effect is interpreted as a pseudo \eqn{R^2}-like measure of explained variance (as in linear models).
It is 0 when persons with the same person parameters yield the same response probabilities.
If two persons with the same person parameter but different covariate values yield different response probabilities,
an additional variance component is introduced and the effect is greater than 0

The power of the tests is computed from the cumulative distribution function of the non-central \eqn{\chi^2} distribution,
where the respective non-centrality parameter is obtained by multiplying the effect with the informative sample size.
This is only an approximation based on results of asymptotic theory. The approximation may be poor when the
informative sample size is small and/or the effect is large.
}
\examples{
\dontrun{
##### Sample size of Rasch Model #####

res <-  sa_sizeRM(local_dev = list( c(0, -0.5, 0, 0.5, 1) , c(0, 0.5, 0, -0.5, 1)))

cml_power(obj = res)

p_curve(obj = res)
p_curve(obj = res, col = "red", lwd = 2, ylim = c(0, 1))

p_ncurve(obj = res)
p_ncurve(obj = res, col = "red", lwd = 2, ylim = c(0, 1))

}
}
\references{
{
Draxler, C., & Kurz, A. (2025). Testing measurement invariance in a conditional likelihood framework by considering
multiple covariates simultaneously. Behavior Research Methods, 57(1), 50.
  }
}
\seealso{
\code{\link{sa_sizeRM}}, \code{\link{sa_sizePCM}}, and \code{\link{sa_sizeChange}}
}
\keyword{sample_size_planning}
